/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js"
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* binding */ AbortedDeferredError),
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   IDLE_BLOCKER: () => (/* binding */ IDLE_BLOCKER),
/* harmony export */   IDLE_FETCHER: () => (/* binding */ IDLE_FETCHER),
/* harmony export */   IDLE_NAVIGATION: () => (/* binding */ IDLE_NAVIGATION),
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: () => (/* binding */ UNSAFE_DEFERRED_SYMBOL),
/* harmony export */   UNSAFE_DeferredData: () => (/* binding */ DeferredData),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* binding */ ErrorResponseImpl),
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: () => (/* binding */ convertRouteMatchToUiMatch),
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: () => (/* binding */ convertRoutesToDataRoutes),
/* harmony export */   UNSAFE_decodePath: () => (/* binding */ decodePath),
/* harmony export */   UNSAFE_getResolveToMatches: () => (/* binding */ getResolveToMatches),
/* harmony export */   UNSAFE_invariant: () => (/* binding */ invariant),
/* harmony export */   UNSAFE_warning: () => (/* binding */ warning),
/* harmony export */   createBrowserHistory: () => (/* binding */ createBrowserHistory),
/* harmony export */   createHashHistory: () => (/* binding */ createHashHistory),
/* harmony export */   createMemoryHistory: () => (/* binding */ createMemoryHistory),
/* harmony export */   createPath: () => (/* binding */ createPath),
/* harmony export */   createRouter: () => (/* binding */ createRouter),
/* harmony export */   createStaticHandler: () => (/* binding */ createStaticHandler),
/* harmony export */   data: () => (/* binding */ data),
/* harmony export */   defer: () => (/* binding */ defer),
/* harmony export */   generatePath: () => (/* binding */ generatePath),
/* harmony export */   getStaticContextFromError: () => (/* binding */ getStaticContextFromError),
/* harmony export */   getToPathname: () => (/* binding */ getToPathname),
/* harmony export */   isDataWithResponseInit: () => (/* binding */ isDataWithResponseInit),
/* harmony export */   isDeferredData: () => (/* binding */ isDeferredData),
/* harmony export */   isRouteErrorResponse: () => (/* binding */ isRouteErrorResponse),
/* harmony export */   joinPaths: () => (/* binding */ joinPaths),
/* harmony export */   json: () => (/* binding */ json),
/* harmony export */   matchPath: () => (/* binding */ matchPath),
/* harmony export */   matchRoutes: () => (/* binding */ matchRoutes),
/* harmony export */   normalizePathname: () => (/* binding */ normalizePathname),
/* harmony export */   parsePath: () => (/* binding */ parsePath),
/* harmony export */   redirect: () => (/* binding */ redirect),
/* harmony export */   redirectDocument: () => (/* binding */ redirectDocument),
/* harmony export */   replace: () => (/* binding */ replace),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   resolveTo: () => (/* binding */ resolveTo),
/* harmony export */   stripBasename: () => (/* binding */ stripBasename)
/* harmony export */ });
/**
 * @remix-run/router v1.23.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, String(index)];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/v6/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  return matchRoutesImpl(routes, locationArg, basename, false);
}
function matchRoutesImpl(routes, locationArg, basename, allowPartial) {
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded, allowPartial);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname, allowPartial) {
  if (allowPartial === void 0) {
    allowPartial = false;
  }
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    let route = meta.route;
    if (!match && end && allowPartial && !routesMeta[routesMeta.length - 1].route.index) {
      match = matchPath({
        path: meta.relativePath,
        caseSensitive: meta.caseSensitive,
        end: false
      }, remainingPathname);
    }
    if (!match) {
      return null;
    }
    Object.assign(matchedParams, match.params);
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/v6/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/v6/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
const ABSOLUTE_URL_REGEX$1 = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const isAbsoluteUrl = url => ABSOLUTE_URL_REGEX$1.test(url);
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/v6/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname;
  if (toPathname) {
    if (isAbsoluteUrl(toPathname)) {
      pathname = toPathname;
    } else {
      if (toPathname.includes("//")) {
        let oldPathname = toPathname;
        toPathname = toPathname.replace(/\/\/+/g, "/");
        warning(false, "Pathnames cannot have embedded double slashes - normalizing " + (oldPathname + " -> " + toPathname));
      }
      if (toPathname.startsWith("/")) {
        pathname = resolvePathname(toPathname.substring(1), "/");
      } else {
        pathname = resolvePathname(toPathname, fromPathname);
      }
    }
  } else {
    pathname = fromPathname;
  }
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === pathMatches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 *
 * @deprecated The `json` method is deprecated in favor of returning raw objects.
 * This method will be removed in v7.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class DataWithResponseInit {
  constructor(data, init) {
    this.type = "DataWithResponseInit";
    this.data = data;
    this.init = init || null;
  }
}
/**
 * Create "responses" that contain `status`/`headers` without forcing
 * serialization into an actual `Response` - used by Remix single fetch
 */
function data(data, init) {
  return new DataWithResponseInit(data, typeof init === "number" ? {
    status: init
  } : init);
}
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
/**
 * @deprecated The `defer` method is deprecated in favor of returning raw
 * objects. This method will be removed in v7.
 */
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * A redirect response that will perform a `history.replaceState` instead of a
 * `history.pushState` for client-side navigation redirects.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const replace = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Replace", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  let dataStrategyImpl = init.dataStrategy || defaultDataStrategy;
  let patchRoutesOnNavigationImpl = init.patchRoutesOnNavigation;
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false,
    v7_skipActionErrorRevalidation: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialMatchesIsFOW = false;
  let initialErrors = null;
  if (initialMatches == null && !patchRoutesOnNavigationImpl) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  // In SPA apps, if the user provided a patchRoutesOnNavigation implementation and
  // our initial match is a splat route, clear them out so we run through lazy
  // discovery on hydration in case there's a more accurate lazy route match.
  // In SSR apps (with `hydrationData`), we expect that the server will send
  // up the proper matched routes so we don't want to run lazy discovery on
  // initial hydration and want to hydrate into the splat route.
  if (initialMatches && !init.hydrationData) {
    let fogOfWar = checkFogOfWar(initialMatches, dataRoutes, init.history.location.pathname);
    if (fogOfWar.active) {
      initialMatches = null;
    }
  }
  let initialized;
  if (!initialMatches) {
    initialized = false;
    initialMatches = [];
    // If partial hydration and fog of war is enabled, we will be running
    // `patchRoutesOnNavigation` during hydration so include any partial matches as
    // the initial matches so we can properly render `HydrateFallback`'s
    if (future.v7_partialHydration) {
      let fogOfWar = checkFogOfWar(null, dataRoutes, init.history.location.pathname);
      if (fogOfWar.active && fogOfWar.matches) {
        initialMatchesIsFOW = true;
        initialMatches = fogOfWar.matches;
      }
    }
  } else if (initialMatches.some(m => m.route.lazy)) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!initialMatches.some(m => m.route.loader)) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    // If errors exist, don't consider routes below the boundary
    if (errors) {
      let idx = initialMatches.findIndex(m => errors[m.route.id] !== undefined);
      initialized = initialMatches.slice(0, idx + 1).every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    } else {
      initialized = initialMatches.every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    }
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = new Set();
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let unblockBlockerHistoryUpdate = undefined;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (unblockBlockerHistoryUpdate) {
        unblockBlockerHistoryUpdate();
        unblockBlockerHistoryUpdate = undefined;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        let nextHistoryUpdatePromise = new Promise(resolve => {
          unblockBlockerHistoryUpdate = resolve;
        });
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked, after the url
            // restoration is also complete.  See:
            // https://github.com/remix-run/react-router/issues/11613
            nextHistoryUpdatePromise.then(() => init.history.go(delta));
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Remove any lingering deleted fetchers that have already been removed
    // from state.fetchers
    deletedFetchers.forEach(key => {
      if (!state.fetchers.has(key) && !fetchControllers.has(key)) {
        deletedFetchersKeys.push(key);
      }
    });
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      viewTransitionOpts: opts.viewTransitionOpts,
      flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    } else {
      // We already called deleteFetcher() on these, can remove them from this
      // Set now that we've handed the keys off to the data layer
      deletedFetchersKeys.forEach(key => deletedFetchers.delete(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    // Commit any in-flight routes at the end of the HMR revalidation "navigation"
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation,
      // Proxy through any rending view transition
      enableViewTransition: pendingViewTransitionEnabled === true
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = opts != null && opts.initialHydration && state.matches && state.matches.length > 0 && !initialMatchesIsFOW ?
    // `matchRoutes()` has already been called if we're in here via `router.initialize()`
    state.matches : matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial hydration will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (matches && state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    let fogOfWar = checkFogOfWar(matches, routesToUse, location.pathname);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let {
        error,
        notFoundMatches,
        route
      } = handleNavigational404(location.pathname);
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionResult;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingActionResult = [findNearestBoundary(matches).route.id, {
        type: ResultType.error,
        error: opts.pendingError
      }];
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionResult = await handleAction(request, location, opts.submission, matches, fogOfWar.active, {
        replace: opts.replace,
        flushSync
      });
      if (actionResult.shortCircuited) {
        return;
      }
      // If we received a 404 from handleAction, it's because we couldn't lazily
      // discover the destination route so we don't want to call loaders
      if (actionResult.pendingActionResult) {
        let [routeId, result] = actionResult.pendingActionResult;
        if (isErrorResult(result) && isRouteErrorResponse(result.error) && result.error.status === 404) {
          pendingNavigationController = null;
          completeNavigation(location, {
            matches: actionResult.matches,
            loaderData: {},
            errors: {
              [routeId]: result.error
            }
          });
          return;
        }
      }
      matches = actionResult.matches || matches;
      pendingActionResult = actionResult.pendingActionResult;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // No need to do fog of war matching again on loader execution
      fogOfWar.active = false;
      // Create a GET request for the loaders
      request = createClientSideRequest(init.history, request.url, request.signal);
    }
    // Call loaders
    let {
      shortCircuited,
      matches: updatedMatches,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, fogOfWar.active, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionResult);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches: updatedMatches || matches
    }, getActionDataForCommit(pendingActionResult), {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, isFogOfWar, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          pendingActionResult: [boundaryId, {
            type: ResultType.error,
            error: discoverResult.error
          }]
        };
      } else if (!discoverResult.matches) {
        let {
          notFoundMatches,
          error,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          pendingActionResult: [route.id, {
            type: ResultType.error,
            error
          }]
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      let results = await callDataStrategy("action", state, request, [actionMatch], matches, null);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        let location = normalizeRedirectLocation(result.response.headers.get("Location"), new URL(request.url), basename, init.history);
        replace = location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(request, result, true, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions to the current location are REPLACE
      // navigations, but if the action threw an error that'll be rendered in
      // an errorElement, we fall back to PUSH so that the user can use the
      // back button to get back to the pre-submission form location to try
      // again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        matches,
        pendingActionResult: [boundaryMatch.route.id, result]
      };
    }
    return {
      matches,
      pendingActionResult: [actionMatch.route.id, result]
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, isFogOfWar, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionResult) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    let shouldUpdateNavigationState = !isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration);
    // When fog of war is enabled, we enter our `loading` state earlier so we
    // can discover new routes during the `loading` state.  We skip this if
    // we've already run actions since we would have done our matching already.
    // If the children() function threw then, we want to proceed with the
    // partial matches it discovered.
    if (isFogOfWar) {
      if (shouldUpdateNavigationState) {
        let actionData = getUpdatedActionData(pendingActionResult);
        updateState(_extends({
          navigation: loadingNavigation
        }, actionData !== undefined ? {
          actionData
        } : {}), {
          flushSync
        });
      }
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          loaderData: {},
          errors: {
            [boundaryId]: discoverResult.error
          }
        };
      } else if (!discoverResult.matches) {
        let {
          error,
          notFoundMatches,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          loaderData: {},
          errors: {
            [route.id]: error
          }
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null
      }, getActionDataForCommit(pendingActionResult), updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    if (shouldUpdateNavigationState) {
      let updates = {};
      if (!isFogOfWar) {
        // Only update navigation/actionNData if we didn't already do it above
        updates.navigation = loadingNavigation;
        let actionData = getUpdatedActionData(pendingActionResult);
        if (actionData !== undefined) {
          updates.actionData = actionData;
        }
      }
      if (revalidatingFetchers.length > 0) {
        updates.fetchers = getUpdatedRevalidatingFetchers(revalidatingFetchers);
      }
      updateState(updates, {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      abortFetcher(rf.key);
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // Preserve SSR errors during partial hydration
    if (future.v7_partialHydration && initialHydration && state.errors) {
      errors = _extends({}, state.errors, errors);
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      matches,
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  function getUpdatedActionData(pendingActionResult) {
    if (pendingActionResult && !isErrorResult(pendingActionResult[1])) {
      // This is cast to `any` currently because `RouteData`uses any and it
      // would be a breaking change to use any.
      // TODO: v7 - change `RouteData` to use `unknown` instead of `any`
      return {
        [pendingActionResult[0]]: pendingActionResult[1].data
      };
    } else if (state.actionData) {
      if (Object.keys(state.actionData).length === 0) {
        return null;
      } else {
        return state.actionData;
      }
    }
  }
  function getUpdatedRevalidatingFetchers(revalidatingFetchers) {
    revalidatingFetchers.forEach(rf => {
      let fetcher = state.fetchers.get(rf.key);
      let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
      state.fetchers.set(rf.key, revalidatingFetcher);
    });
    return new Map(state.fetchers);
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    abortFetcher(key);
    let flushSync = (opts && opts.flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    let fogOfWar = checkFogOfWar(matches, routesToUse, normalizedPath);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    let preventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, isFogOfWar, flushSync, preventScrollReset, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    function detectAndHandle405Error(m) {
      if (!m.route.action && !m.route.lazy) {
        let error = getInternalRouterError(405, {
          method: submission.formMethod,
          pathname: path,
          routeId: routeId
        });
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return true;
      }
      return false;
    }
    if (!isFogOfWar && detectAndHandle405Error(match)) {
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(requestMatches, new URL(fetchRequest.url).pathname, fetchRequest.signal, key);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        requestMatches = discoverResult.matches;
        match = getTargetMatch(requestMatches, path);
        if (detectAndHandle405Error(match)) {
          return;
        }
      }
    }
    // Call the action for the fetcher
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResults = await callDataStrategy("action", state, fetchRequest, [match], requestMatches, key);
    let actionResult = actionResults[match.route.id];
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(fetchRequest, actionResult, false, {
            fetcherSubmission: submission,
            preventScrollReset
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, [match.route.id, actionResult]);
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      abortFetcher(staleKey);
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, isFogOfWar, flushSync, preventScrollReset, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, new URL(fetchRequest.url).pathname, fetchRequest.signal, key);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        matches = discoverResult.matches;
        match = getTargetMatch(matches, path);
      }
    }
    // Call the loader for this fetcher route match
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let results = await callDataStrategy("loader", state, fetchRequest, [match], matches, key);
    let result = results[match.route.id];
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(fetchRequest, result, false, {
          preventScrollReset
        });
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(request, redirect, isNavigation, _temp2) {
    let {
      submission,
      fetcherSubmission,
      preventScrollReset,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.response.headers.has("X-Remix-Revalidate")) {
      isRevalidationRequired = true;
    }
    let location = redirect.response.headers.get("Location");
    invariant(location, "Expected a Location header on the redirect Response");
    location = normalizeRedirectLocation(location, new URL(request.url), basename, init.history);
    let redirectLocation = createLocation(state.location, location, {
      _isRedirect: true
    });
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.response.headers.has("X-Remix-Reload-Document")) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(location)) {
        const url = init.history.createURL(location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(location);
        } else {
          routerWindow.location.assign(location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true || redirect.response.headers.has("X-Remix-Replace") ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.response.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: location
        }),
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    }
  }
  // Utility wrapper for calling dataStrategy client-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, state, request, matchesToLoad, matches, fetcherKey) {
    let results;
    let dataResults = {};
    try {
      results = await callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties);
    } catch (e) {
      // If the outer dataStrategy method throws, just return the error for all
      // matches - and it'll naturally bubble to the root
      matchesToLoad.forEach(m => {
        dataResults[m.route.id] = {
          type: ResultType.error,
          error: e
        };
      });
      return dataResults;
    }
    for (let [routeId, result] of Object.entries(results)) {
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        dataResults[routeId] = {
          type: ResultType.redirect,
          response: normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, future.v7_relativeSplatPath)
        };
      } else {
        dataResults[routeId] = await convertDataStrategyResultToDataResult(result);
      }
    }
    return dataResults;
  }
  async function callLoadersAndMaybeResolveData(state, matches, matchesToLoad, fetchersToLoad, request) {
    let currentMatches = state.matches;
    // Kick off loaders and fetchers in parallel
    let loaderResultsPromise = callDataStrategy("loader", state, request, matchesToLoad, matches, null);
    let fetcherResultsPromise = Promise.all(fetchersToLoad.map(async f => {
      if (f.matches && f.match && f.controller) {
        let results = await callDataStrategy("loader", state, createClientSideRequest(init.history, f.path, f.controller.signal), [f.match], f.matches, f.key);
        let result = results[f.match.route.id];
        // Fetcher results are keyed by fetcher key from here on out, not routeId
        return {
          [f.key]: result
        };
      } else {
        return Promise.resolve({
          [f.key]: {
            type: ResultType.error,
            error: getInternalRouterError(404, {
              pathname: f.path
            })
          }
        });
      }
    }));
    let loaderResults = await loaderResultsPromise;
    let fetcherResults = (await fetcherResultsPromise).reduce((acc, r) => Object.assign(acc, r), {});
    await Promise.all([resolveNavigationDeferredResults(matches, loaderResults, request.signal, currentMatches, state.loaderData), resolveFetcherDeferredResults(matches, fetcherResults, fetchersToLoad)]);
    return {
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.add(key);
      }
      abortFetcher(key);
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
    // If this fetcher was previously marked for deletion, unmark it since we
    // have a new instance
    if (deletedFetchers.has(key)) {
      deletedFetchers.delete(key);
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    // If we opted into the flag we can clear this now since we're calling
    // deleteFetcher() at the end of updateState() and we've already handed the
    // deleted fetcher keys off to the data layer.
    // If not, we're eagerly calling deleteFetcher() and we need to keep this
    // Set populated until the next updateState call, and we'll clear
    // `deletedFetchers` then
    if (future.v7_fetcherPersist) {
      deletedFetchers.delete(key);
    }
    cancelledFetcherLoads.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    let count = (activeFetchers.get(key) || 0) - 1;
    if (count <= 0) {
      activeFetchers.delete(key);
      deletedFetchers.add(key);
      if (!future.v7_fetcherPersist) {
        deleteFetcher(key);
      }
    } else {
      activeFetchers.set(key, count);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    if (controller) {
      controller.abort();
      fetchControllers.delete(key);
    }
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref2) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref2;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function handleNavigational404(pathname) {
    let error = getInternalRouterError(404, {
      pathname
    });
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let {
      matches,
      route
    } = getShortCircuitMatches(routesToUse);
    // Cancel all pending deferred on 404s since we don't keep any routes
    cancelActiveDeferreds();
    return {
      notFoundMatches: matches,
      route,
      error
    };
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function checkFogOfWar(matches, routesToUse, pathname) {
    if (patchRoutesOnNavigationImpl) {
      if (!matches) {
        let fogMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
        return {
          active: true,
          matches: fogMatches || []
        };
      } else {
        if (Object.keys(matches[0].params).length > 0) {
          // If we matched a dynamic param or a splat, it might only be because
          // we haven't yet discovered other routes that would match with a
          // higher score.  Call patchRoutesOnNavigation just to be sure
          let partialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
          return {
            active: true,
            matches: partialMatches
          };
        }
      }
    }
    return {
      active: false,
      matches: null
    };
  }
  async function discoverRoutes(matches, pathname, signal, fetcherKey) {
    if (!patchRoutesOnNavigationImpl) {
      return {
        type: "success",
        matches
      };
    }
    let partialMatches = matches;
    while (true) {
      let isNonHMR = inFlightDataRoutes == null;
      let routesToUse = inFlightDataRoutes || dataRoutes;
      let localManifest = manifest;
      try {
        await patchRoutesOnNavigationImpl({
          signal,
          path: pathname,
          matches: partialMatches,
          fetcherKey,
          patch: (routeId, children) => {
            if (signal.aborted) return;
            patchRoutesImpl(routeId, children, routesToUse, localManifest, mapRouteProperties);
          }
        });
      } catch (e) {
        return {
          type: "error",
          error: e,
          partialMatches
        };
      } finally {
        // If we are not in the middle of an HMR revalidation and we changed the
        // routes, provide a new identity so when we `updateState` at the end of
        // this navigation/fetch `router.routes` will be a new identity and
        // trigger a re-run of memoized `router.routes` dependencies.
        // HMR will already update the identity and reflow when it lands
        // `inFlightDataRoutes` in `completeNavigation`
        if (isNonHMR && !signal.aborted) {
          dataRoutes = [...dataRoutes];
        }
      }
      if (signal.aborted) {
        return {
          type: "aborted"
        };
      }
      let newMatches = matchRoutes(routesToUse, pathname, basename);
      if (newMatches) {
        return {
          type: "success",
          matches: newMatches
        };
      }
      let newPartialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
      // Avoid loops if the second pass results in the same partial matches
      if (!newPartialMatches || partialMatches.length === newPartialMatches.length && partialMatches.every((m, i) => m.route.id === newPartialMatches[i].route.id)) {
        return {
          type: "success",
          matches: null
        };
      }
      partialMatches = newPartialMatches;
    }
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  function patchRoutes(routeId, children) {
    let isNonHMR = inFlightDataRoutes == null;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties);
    // If we are not in the middle of an HMR revalidation and we changed the
    // routes, provide a new identity and trigger a reflow via `updateState`
    // to re-run memoized `router.routes` dependencies.
    // HMR will already update the identity and reflow when it lands
    // `inFlightDataRoutes` in `completeNavigation`
    if (isNonHMR) {
      dataRoutes = [...dataRoutes];
      updateState({});
    }
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    patchRoutes,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   *
   * - `opts.requestContext` is an optional server context that will be passed
   *   to actions/loaders in the `context` parameter
   * - `opts.skipLoaderErrorBubbling` is an optional parameter that will prevent
   *   the bubbling of errors which allows single-fetch-type implementations
   *   where the client will handle the bubbling and we may need to return data
   *   for the handling route
   */
  async function query(request, _temp3) {
    let {
      requestContext,
      skipLoaderErrorBubbling,
      dataStrategy
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, skipLoaderErrorBubbling === true, null);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   *
   * - `opts.routeId` allows you to specify the specific route handler to call.
   *   If not provided the handler will determine the proper route by matching
   *   against `request.url`
   * - `opts.requestContext` is an optional server context that will be passed
   *    to actions/loaders in the `context` parameter
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext,
      dataStrategy
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, false, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction for a
      // `queryRoute` call, we throw the `DataStrategyResult` to bail out early
      // and then return or throw the raw Response here accordingly
      if (isDataStrategyResult(e) && isResponse(e.result)) {
        if (e.type === ResultType.error) {
          throw e.result;
        }
        return e.result;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, dataStrategy, skipLoaderErrorBubbling, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches, isRouteRequest, requestContext, dataStrategy);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.response.status,
        headers: {
          Location: result.response.headers.get("Location")
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = skipLoaderErrorBubbling ? actionMatch : findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null, [boundaryMatch.route.id, result]);
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : result.statusCode != null ? result.statusCode : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null);
    return _extends({}, context, {
      actionData: {
        [actionMatch.route.id]: result.data
      }
    }, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionHeaders: result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {}
    });
  }
  async function loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch, pendingActionResult) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : pendingActionResult && isErrorResult(pendingActionResult[1]) ? getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]) : matches;
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await callDataStrategy("loader", request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  // Utility wrapper for calling dataStrategy server-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy) {
    let results = await callDataStrategyImpl(dataStrategy || defaultDataStrategy, type, null, request, matchesToLoad, matches, null, manifest, mapRouteProperties, requestContext);
    let dataResults = {};
    await Promise.all(matches.map(async match => {
      if (!(match.route.id in results)) {
        return;
      }
      let result = results[match.route.id];
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        // Throw redirects and let the server handle them with an HTTP redirect
        throw normalizeRelativeRoutingRedirectResponse(response, request, match.route.id, matches, basename, future.v7_relativeSplatPath);
      }
      if (isResponse(result.result) && isRouteRequest) {
        // For SSR single-route requests, we want to hand Responses back
        // directly without unwrapping
        throw result;
      }
      dataResults[match.route.id] = await convertDataStrategyResultToDataResult(result);
    }));
    return dataResults;
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Account for `?index` params when routing to the current location
  if ((to == null || to === "" || to === ".") && activeRouteMatch) {
    let nakedIndex = hasNakedIndexQuery(path.search);
    if (activeRouteMatch.route.index && !nakedIndex) {
      // Add one when we're targeting an index route
      path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
    } else if (!activeRouteMatch.route.index && nakedIndex) {
      // Remove existing ones when we're not
      let params = new URLSearchParams(path.search);
      let indexValues = params.getAll("index");
      params.delete("index");
      indexValues.filter(v => v).forEach(v => params.append("index", v));
      let qs = params.toString();
      path.search = qs ? "?" + qs : "";
    }
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref3) => {
        let [name, value] = _ref3;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes at/below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId, includeBoundary) {
  if (includeBoundary === void 0) {
    includeBoundary = false;
  }
  let index = matches.findIndex(m => m.route.id === boundaryId);
  if (index >= 0) {
    return matches.slice(0, includeBoundary ? index + 1 : index);
  }
  return matches;
}
function getMatchesToLoad(history, state, matches, submission, location, initialHydration, skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult) {
  let actionResult = pendingActionResult ? isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : pendingActionResult[1].data : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryMatches = matches;
  if (initialHydration && state.errors) {
    // On initial hydration, only consider matches up to _and including_ the boundary.
    // This is inclusive to handle cases where a server loader ran successfully,
    // a child server loader bubbled up to this route, but this route has
    // `clientLoader.hydrate` so we want to still run the `clientLoader` so that
    // we have a complete version of `loaderData`
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, Object.keys(state.errors)[0], true);
  } else if (pendingActionResult && isErrorResult(pendingActionResult[1])) {
    // If an action threw an error, we call loaders up to, but not including the
    // boundary
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]);
  }
  // Don't revalidate loaders by default after action 4xx/5xx responses
  // when the flag is enabled.  They can still opt-into revalidation via
  // `shouldRevalidate` via `actionResult`
  let actionStatus = pendingActionResult ? pendingActionResult[1].statusCode : undefined;
  let shouldSkipRevalidation = skipActionErrorRevalidation && actionStatus && actionStatus >= 400;
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (initialHydration) {
      return shouldLoadRouteOnHydration(route, state.loaderData, state.errors);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      actionStatus,
      defaultShouldRevalidate: shouldSkipRevalidation ? false :
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired || currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial hydration (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (initialHydration || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.has(key)) {
      // Always mark for revalidation if the fetcher was cancelled
      cancelledFetcherLoads.delete(key);
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        actionStatus,
        defaultShouldRevalidate: shouldSkipRevalidation ? false : isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function shouldLoadRouteOnHydration(route, loaderData, errors) {
  // We dunno if we have a loader - gotta find out!
  if (route.lazy) {
    return true;
  }
  // No loader, nothing to initialize
  if (!route.loader) {
    return false;
  }
  let hasData = loaderData != null && loaderData[route.id] !== undefined;
  let hasError = errors != null && errors[route.id] !== undefined;
  // Don't run if we error'd during SSR
  if (!hasData && hasError) {
    return false;
  }
  // Explicitly opting-in to running on hydration
  if (typeof route.loader === "function" && route.loader.hydrate === true) {
    return true;
  }
  // Otherwise, run if we're not yet initialized with anything
  return !hasData && !hasError;
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
function patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties) {
  var _childrenToPatch;
  let childrenToPatch;
  if (routeId) {
    let route = manifest[routeId];
    invariant(route, "No route found to patch children into: routeId = " + routeId);
    if (!route.children) {
      route.children = [];
    }
    childrenToPatch = route.children;
  } else {
    childrenToPatch = routesToUse;
  }
  // Don't patch in routes we already know about so that `patch` is idempotent
  // to simplify user-land code. This is useful because we re-call the
  // `patchRoutesOnNavigation` function for matched routes with params.
  let uniqueChildren = children.filter(newRoute => !childrenToPatch.some(existingRoute => isSameRoute(newRoute, existingRoute)));
  let newRoutes = convertRoutesToDataRoutes(uniqueChildren, mapRouteProperties, [routeId || "_", "patch", String(((_childrenToPatch = childrenToPatch) == null ? void 0 : _childrenToPatch.length) || "0")], manifest);
  childrenToPatch.push(...newRoutes);
}
function isSameRoute(newRoute, existingRoute) {
  // Most optimal check is by id
  if ("id" in newRoute && "id" in existingRoute && newRoute.id === existingRoute.id) {
    return true;
  }
  // Second is by pathing differences
  if (!(newRoute.index === existingRoute.index && newRoute.path === existingRoute.path && newRoute.caseSensitive === existingRoute.caseSensitive)) {
    return false;
  }
  // Pathless layout routes are trickier since we need to check children.
  // If they have no children then they're the same as far as we can tell
  if ((!newRoute.children || newRoute.children.length === 0) && (!existingRoute.children || existingRoute.children.length === 0)) {
    return true;
  }
  // Otherwise, we look to see if every child in the new route is already
  // represented in the existing route's children
  return newRoute.children.every((aChild, i) => {
    var _existingRoute$childr;
    return (_existingRoute$childr = existingRoute.children) == null ? void 0 : _existingRoute$childr.some(bChild => isSameRoute(aChild, bChild));
  });
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
// Default implementation of `dataStrategy` which fetches all loaders in parallel
async function defaultDataStrategy(_ref4) {
  let {
    matches
  } = _ref4;
  let matchesToLoad = matches.filter(m => m.shouldLoad);
  let results = await Promise.all(matchesToLoad.map(m => m.resolve()));
  return results.reduce((acc, result, i) => Object.assign(acc, {
    [matchesToLoad[i].route.id]: result
  }), {});
}
async function callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties, requestContext) {
  let loadRouteDefinitionsPromises = matches.map(m => m.route.lazy ? loadLazyRouteModule(m.route, mapRouteProperties, manifest) : undefined);
  let dsMatches = matches.map((match, i) => {
    let loadRoutePromise = loadRouteDefinitionsPromises[i];
    let shouldLoad = matchesToLoad.some(m => m.route.id === match.route.id);
    // `resolve` encapsulates route.lazy(), executing the loader/action,
    // and mapping return values/thrown errors to a `DataStrategyResult`.  Users
    // can pass a callback to take fine-grained control over the execution
    // of the loader/action
    let resolve = async handlerOverride => {
      if (handlerOverride && request.method === "GET" && (match.route.lazy || match.route.loader)) {
        shouldLoad = true;
      }
      return shouldLoad ? callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, requestContext) : Promise.resolve({
        type: ResultType.data,
        result: undefined
      });
    };
    return _extends({}, match, {
      shouldLoad,
      resolve
    });
  });
  // Send all matches here to allow for a middleware-type implementation.
  // handler will be a no-op for unneeded routes and we filter those results
  // back out below.
  let results = await dataStrategyImpl({
    matches: dsMatches,
    request,
    params: matches[0].params,
    fetcherKey,
    context: requestContext
  });
  // Wait for all routes to load here but 'swallow the error since we want
  // it to bubble up from the `await loadRoutePromise` in `callLoaderOrAction` -
  // called from `match.resolve()`
  try {
    await Promise.all(loadRouteDefinitionsPromises);
  } catch (e) {
    // No-op
  }
  return results;
}
// Default logic for calling a loader/action is the user has no specified a dataStrategy
async function callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, staticContext) {
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    // This will never resolve so safe to type it as Promise<DataStrategyResult> to
    // satisfy the function return value
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    let actualHandler = ctx => {
      if (typeof handler !== "function") {
        return Promise.reject(new Error("You cannot call the handler for a route which defines a boolean " + ("\"" + type + "\" [routeId: " + match.route.id + "]")));
      }
      return handler({
        request,
        params: match.params,
        context: staticContext
      }, ...(ctx !== undefined ? [ctx] : []));
    };
    let handlerPromise = (async () => {
      try {
        let val = await (handlerOverride ? handlerOverride(ctx => actualHandler(ctx)) : actualHandler());
        return {
          type: "data",
          result: val
        };
      } catch (e) {
        return {
          type: "error",
          result: e
        };
      }
    })();
    return Promise.race([handlerPromise, abortPromise]);
  };
  try {
    let handler = match.route[type];
    // If we have a route.lazy promise, await that first
    if (loadRoutePromise) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let [value] = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadRoutePromise]);
        if (handlerError !== undefined) {
          throw handlerError;
        }
        result = value;
      } else {
        // Load lazy route module, then run any returned handler
        await loadRoutePromise;
        handler = match.route[type];
        if (handler) {
          // Handler still runs even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            result: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result.result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    // We should already be catching and converting normal handler executions to
    // DataStrategyResults and returning them, so anything that throws here is an
    // unexpected error we still need to wrap
    return {
      type: ResultType.error,
      result: e
    };
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  return result;
}
async function convertDataStrategyResultToDataResult(dataStrategyResult) {
  let {
    result,
    type
  } = dataStrategyResult;
  if (isResponse(result)) {
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (type === ResultType.error) {
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(result.status, result.statusText, data),
        statusCode: result.status,
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (type === ResultType.error) {
    if (isDataWithResponseInit(result)) {
      var _result$init3, _result$init4;
      if (result.data instanceof Error) {
        var _result$init, _result$init2;
        return {
          type: ResultType.error,
          error: result.data,
          statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status,
          headers: (_result$init2 = result.init) != null && _result$init2.headers ? new Headers(result.init.headers) : undefined
        };
      }
      // Convert thrown data() to ErrorResponse instances
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(((_result$init3 = result.init) == null ? void 0 : _result$init3.status) || 500, undefined, result.data),
        statusCode: isRouteErrorResponse(result) ? result.status : undefined,
        headers: (_result$init4 = result.init) != null && _result$init4.headers ? new Headers(result.init.headers) : undefined
      };
    }
    return {
      type: ResultType.error,
      error: result,
      statusCode: isRouteErrorResponse(result) ? result.status : undefined
    };
  }
  if (isDeferredData(result)) {
    var _result$init5, _result$init6;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init5 = result.init) == null ? void 0 : _result$init5.status,
      headers: ((_result$init6 = result.init) == null ? void 0 : _result$init6.headers) && new Headers(result.init.headers)
    };
  }
  if (isDataWithResponseInit(result)) {
    var _result$init7, _result$init8;
    return {
      type: ResultType.data,
      data: result.data,
      statusCode: (_result$init7 = result.init) == null ? void 0 : _result$init7.status,
      headers: (_result$init8 = result.init) != null && _result$init8.headers ? new Headers(result.init.headers) : undefined
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Support relative routing in internal redirects
function normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, v7_relativeSplatPath) {
  let location = response.headers.get("Location");
  invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
  if (!ABSOLUTE_URL_REGEX.test(location)) {
    let trimmedMatches = matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1);
    location = normalizeTo(new URL(request.url), trimmedMatches, basename, true, location, v7_relativeSplatPath);
    response.headers.set("Location", location);
  }
  return response;
}
function normalizeRedirectLocation(location, currentUrl, basename, historyInstance) {
  // Match Chrome's behavior:
  // https://github.com/chromium/chromium/blob/216dbeb61db0c667e62082e5f5400a32d6983df3/content/public/common/url_utils.cc#L82
  let invalidProtocols = ["about:", "blob:", "chrome:", "chrome-untrusted:", "content:", "data:", "devtools:", "file:", "filesystem:",
  // eslint-disable-next-line no-script-url
  "javascript:"];
  if (ABSOLUTE_URL_REGEX.test(location)) {
    // Strip off the protocol+origin for same-origin + same-basename absolute redirects
    let normalizedLocation = location;
    let url = normalizedLocation.startsWith("//") ? new URL(currentUrl.protocol + normalizedLocation) : new URL(normalizedLocation);
    if (invalidProtocols.includes(url.protocol)) {
      throw new Error("Invalid redirect location");
    }
    let isSameBasename = stripBasename(url.pathname, basename) != null;
    if (url.origin === currentUrl.origin && isSameBasename) {
      return url.pathname + url.search + url.hash;
    }
  }
  try {
    let url = historyInstance.createURL(location);
    if (invalidProtocols.includes(url.protocol)) {
      throw new Error("Invalid redirect location");
    }
  } catch (e) {}
  return location;
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  let pendingError = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : undefined;
  // Process loader results into state.loaderData/state.errors
  matches.forEach(match => {
    if (!(match.route.id in results)) {
      return;
    }
    let id = match.route.id;
    let result = results[id];
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError !== undefined) {
        error = pendingError;
        pendingError = undefined;
      }
      errors = errors || {};
      if (skipLoaderErrorBubbling) {
        errors[id] = error;
      } else {
        // Look upwards from the matched route for the closest ancestor error
        // boundary, defaulting to the root match.  Prefer higher error values
        // if lower errors bubble to the same boundary
        let boundaryMatch = findNearestBoundary(matches, id);
        if (errors[boundaryMatch.route.id] == null) {
          errors[boundaryMatch.route.id] = error;
        }
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      } else {
        loaderData[id] = result.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError !== undefined && pendingActionResult) {
    errors = {
      [pendingActionResult[0]]: pendingError
    };
    loaderData[pendingActionResult[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, results, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, false // This method is only called client side so we always want to bubble
  );
  // Process results from our revalidating fetchers
  revalidatingFetchers.forEach(rf => {
    let {
      key,
      match,
      controller
    } = rf;
    let result = fetcherResults[key];
    invariant(result, "Did not find corresponding fetcher result");
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      return;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  });
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
function getActionDataForCommit(pendingActionResult) {
  if (!pendingActionResult) {
    return {};
  }
  return isErrorResult(pendingActionResult[1]) ? {
    // Clear out prior actionData on errors
    actionData: {}
  } : {
    actionData: {
      [pendingActionResult[0]]: pendingActionResult[1].data
    }
  };
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type,
    message
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  let entries = Object.entries(results);
  for (let i = entries.length - 1; i >= 0; i--) {
    let [key, result] = entries[i];
    if (isRedirectResult(result)) {
      return {
        key,
        result
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isDataStrategyResult(result) {
  return result != null && typeof result === "object" && "type" in result && "result" in result && (result.type === ResultType.data || result.type === ResultType.error);
}
function isRedirectDataStrategyResultResult(result) {
  return isResponse(result.result) && redirectStatusCodes.has(result.result.status);
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDataWithResponseInit(value) {
  return typeof value === "object" && value != null && "type" in value && "data" in value && "init" in value && value.type === "DataWithResponseInit";
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveNavigationDeferredResults(matches, results, signal, currentMatches, currentLoaderData) {
  let entries = Object.entries(results);
  for (let index = 0; index < entries.length; index++) {
    let [routeId, result] = entries[index];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && isRevalidatingLoader) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      await resolveDeferredData(result, signal, false).then(result => {
        if (result) {
          results[routeId] = result;
        }
      });
    }
  }
}
async function resolveFetcherDeferredResults(matches, results, revalidatingFetchers) {
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      routeId,
      controller
    } = revalidatingFetchers[index];
    let result = results[key];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    if (isDeferredResult(result)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      invariant(controller, "Expected an AbortController for revalidating fetcher deferred result");
      await resolveDeferredData(result, controller.signal, true).then(result => {
        if (result) {
          results[key] = result;
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ },

/***/ "./src/components/Card/index.jsx"
/*!***************************************!*\
  !*** ./src/components/Card/index.jsx ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Card({
  cardList,
  cardPlace,
  cardCol
}) {
  const cardListing = card => {
    return card.map((carditem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-cardbody",
        key: index
      }, carditem.iconSvg || carditem.imageurl && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon"
      }, carditem.iconSvg && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cw-icon-svg"
      }, carditem.iconSvg), carditem.imageurl && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-text-wrap"
      }, carditem.heading && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)), carditem.para && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "cw-text"
      }, carditem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, carditem.buttonUrl && carditem.buttonText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "cw-btn"
      }, carditem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "arrow"
      }))), cardPlace === 'starter' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "preview"
      })))), cardPlace === 'cw-pro' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "lock"
      }))));
    });
  };
  const classes = `cw-card ${cardPlace} ${cardCol}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classes
  }, cardListing(cardList)));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);

/***/ },

/***/ "./src/components/Heading/index.jsx"
/*!******************************************!*\
  !*** ./src/components/Heading/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Heading)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Heading({
  heading,
  buttonText,
  buttonUrl,
  openInNewTab
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, heading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: buttonUrl,
    className: "cw-btn",
    target: openInNewTab ? "_blank" : "_self"
  }, buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))));
}

/***/ },

/***/ "./src/components/Icon/index.jsx"
/*!***************************************!*\
  !*** ./src/components/Icon/index.jsx ***!
  \***************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const icons = {
  globe: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_336)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665C12.0844 3.94846 13.269 6.90987 13.3333 9.99984C13.269 13.0898 12.0844 16.0512 10 18.3332M10 1.6665C7.9156 3.94846 6.73104 6.90987 6.66667 9.99984C6.73104 13.0898 7.9156 16.0512 10 18.3332M10 1.6665C5.39763 1.6665 1.66667 5.39746 1.66667 9.99984C1.66667 14.6022 5.39763 18.3332 10 18.3332M10 1.6665C14.6024 1.6665 18.3333 5.39746 18.3333 9.99984C18.3333 14.6022 14.6024 18.3332 10 18.3332M2.08335 7.49984H17.9167M2.08334 12.4998H17.9167",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_336"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20"
  })))),
  site: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1212)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.16669 13.5H24.1667M14.1667 13.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1212",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  colorsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1220)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2353_1220)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.66669 16C7.66669 20.6024 11.3976 24.3334 16 24.3334C17.3807 24.3334 18.5 23.2141 18.5 21.8334V21.4167C18.5 21.0297 18.5 20.8362 18.5214 20.6737C18.6691 19.5519 19.5519 18.6691 20.6737 18.5214C20.8362 18.5 21.0297 18.5 21.4167 18.5H21.8334C23.2141 18.5 24.3334 17.3807 24.3334 16C24.3334 11.3976 20.6024 7.66669 16 7.66669C11.3976 7.66669 7.66669 11.3976 7.66669 16Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.8334 16.8334C12.2936 16.8334 12.6667 16.4603 12.6667 16C12.6667 15.5398 12.2936 15.1667 11.8334 15.1667C11.3731 15.1667 11 15.5398 11 16C11 16.4603 11.3731 16.8334 11.8334 16.8334Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.3334 13.5C19.7936 13.5 20.1667 13.1269 20.1667 12.6667C20.1667 12.2064 19.7936 11.8334 19.3334 11.8334C18.8731 11.8334 18.5 12.2064 18.5 12.6667C18.5 13.1269 18.8731 13.5 19.3334 13.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.3334 12.6667C14.7936 12.6667 15.1667 12.2936 15.1667 11.8334C15.1667 11.3731 14.7936 11 14.3334 11C13.8731 11 13.5 11.3731 13.5 11.8334C13.5 12.2936 13.8731 12.6667 14.3334 12.6667Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1220",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F5B841"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF7830"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2353_1220"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "white",
    transform: "translate(6 6)"
  })))),
  typographysetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1228)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66669 11.8333C9.66669 11.0567 9.66669 10.6685 9.79355 10.3622C9.96271 9.95379 10.2872 9.62934 10.6955 9.46018C11.0018 9.33331 11.3901 9.33331 12.1667 9.33331H20.5C21.2766 9.33331 21.6649 9.33331 21.9712 9.46018C22.3795 9.62934 22.704 9.95379 22.8732 10.3622C23 10.6685 23 11.0567 23 11.8333M13 22.6666H19.6667M14.875 9.33331V22.6666M17.7917 9.33331V22.6666",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1228",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#FF0D76"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#590FB7"
  })))),
  layoutsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1237)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.25 15.1667H17.0834M21.25 18.5H17.0834M21.25 11.8333H17.0834M14.1667 8.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1237",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F40076"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#DF98FA"
  })))),
  frontpagesetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1245)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.3334 13.5H7.66669M17.6667 20.5833L19.75 18.5L17.6667 16.4167M14.3334 16.4167L12.25 18.5L14.3334 20.5833M7.66669 12.5L7.66669 19.5C7.66669 20.9001 7.66669 21.6002 7.93917 22.135C8.17885 22.6054 8.56131 22.9878 9.03171 23.2275C9.56649 23.5 10.2666 23.5 11.6667 23.5H20.3334C21.7335 23.5 22.4336 23.5 22.9683 23.2275C23.4387 22.9878 23.8212 22.6054 24.0609 22.135C24.3334 21.6002 24.3334 20.9001 24.3334 19.5V12.5C24.3334 11.0999 24.3334 10.3998 24.0609 9.86502C23.8212 9.39462 23.4387 9.01217 22.9683 8.77248C22.4336 8.5 21.7335 8.5 20.3334 8.5L11.6667 8.5C10.2666 8.5 9.56649 8.5 9.03171 8.77248C8.56131 9.01217 8.17885 9.39462 7.93917 9.86502C7.66669 10.3998 7.66669 11.0999 7.66669 12.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1245",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#AFD759"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00B3CC"
  })))),
  generalsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1253)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.1626 22.1426L14.6497 23.2379C14.7944 23.564 15.0307 23.841 15.3298 24.0355C15.629 24.2299 15.9781 24.3334 16.3348 24.3333C16.6916 24.3334 17.0407 24.2299 17.3398 24.0355C17.639 23.841 17.8752 23.564 18.02 23.2379L18.5071 22.1426C18.6804 21.7539 18.9721 21.4298 19.3404 21.2166C19.711 21.0028 20.1398 20.9117 20.5654 20.9564L21.7571 21.0833C22.1118 21.1208 22.4698 21.0546 22.7876 20.8927C23.1055 20.7308 23.3695 20.4802 23.5478 20.1713C23.7263 19.8625 23.8113 19.5085 23.7926 19.1524C23.7738 18.7962 23.6521 18.4531 23.4422 18.1648L22.7367 17.1953C22.4855 16.8476 22.3512 16.429 22.3534 16C22.3533 15.5721 22.4888 15.1553 22.7404 14.8092L23.4459 13.8398C23.6558 13.5514 23.7775 13.2084 23.7963 12.8522C23.815 12.496 23.73 12.1421 23.5515 11.8333C23.3733 11.5243 23.1092 11.2737 22.7913 11.1118C22.4735 10.9499 22.1155 10.8837 21.7608 10.9213L20.5691 11.0481C20.1435 11.0928 19.7148 11.0017 19.3441 10.7879C18.975 10.5735 18.6833 10.2478 18.5108 9.85737L18.02 8.762C17.8752 8.43594 17.639 8.15889 17.3398 7.96446C17.0407 7.77003 16.6916 7.66657 16.3348 7.66663C15.9781 7.66657 15.629 7.77003 15.3298 7.96446C15.0307 8.15889 14.7944 8.43594 14.6497 8.762L14.1626 9.85737C13.9901 10.2478 13.6983 10.5735 13.3293 10.7879C12.9586 11.0017 12.5298 11.0928 12.1043 11.0481L10.9089 10.9213C10.5542 10.8837 10.1962 10.9499 9.87834 11.1118C9.56049 11.2737 9.29643 11.5243 9.11817 11.8333C8.93969 12.1421 8.85466 12.496 8.87339 12.8522C8.89213 13.2084 9.01383 13.5514 9.22373 13.8398L9.92928 14.8092C10.1809 15.1553 10.3164 15.5721 10.3163 16C10.3164 16.4278 10.1809 16.8447 9.92928 17.1907L9.22373 18.1601C9.01383 18.4485 8.89213 18.7916 8.87339 19.1477C8.85466 19.5039 8.93969 19.8578 9.11817 20.1666C9.2966 20.4754 9.5607 20.7259 9.8785 20.8878C10.1963 21.0496 10.5542 21.1159 10.9089 21.0787L12.1006 20.9518C12.5261 20.9071 12.9549 20.9982 13.3256 21.212C13.696 21.4258 13.9891 21.7516 14.1626 22.1426Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M16.3333 18.5C17.7141 18.5 18.8333 17.3807 18.8333 16C18.8333 14.6192 17.7141 13.5 16.3333 13.5C14.9526 13.5 13.8333 14.6192 13.8333 16C13.8333 17.3807 14.9526 18.5 16.3333 18.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1253",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#ED7B84"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  instagramsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1262)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1667 7.66663H20.1667C22.8334 7.66663 25 9.83329 25 12.5V19.5C25 20.7818 24.4908 22.0112 23.5844 22.9176C22.678 23.8241 21.4486 24.3333 20.1667 24.3333H13.1667C10.5 24.3333 8.33337 22.1666 8.33337 19.5V12.5C8.33337 11.2181 8.8426 9.9887 9.74902 9.08228C10.6555 8.17585 11.8848 7.66663 13.1667 7.66663ZM13 9.33329C12.2044 9.33329 11.4413 9.64936 10.8787 10.212C10.3161 10.7746 10 11.5376 10 12.3333V19.6666C10 21.325 11.3417 22.6666 13 22.6666H20.3334C21.129 22.6666 21.8921 22.3506 22.4547 21.7879C23.0173 21.2253 23.3334 20.4623 23.3334 19.6666V12.3333C23.3334 10.675 21.9917 9.33329 20.3334 9.33329H13ZM21.0417 10.5833C21.318 10.5833 21.5829 10.693 21.7783 10.8884C21.9736 11.0837 22.0834 11.3487 22.0834 11.625C22.0834 11.9012 21.9736 12.1662 21.7783 12.3615C21.5829 12.5569 21.318 12.6666 21.0417 12.6666C20.7654 12.6666 20.5005 12.5569 20.3051 12.3615C20.1098 12.1662 20 11.9012 20 11.625C20 11.3487 20.1098 11.0837 20.3051 10.8884C20.5005 10.693 20.7654 10.5833 21.0417 10.5833ZM16.6667 11.8333C17.7718 11.8333 18.8316 12.2723 19.613 13.0537C20.3944 13.8351 20.8334 14.8949 20.8334 16C20.8334 17.105 20.3944 18.1648 19.613 18.9462C18.8316 19.7276 17.7718 20.1666 16.6667 20.1666C15.5616 20.1666 14.5018 19.7276 13.7204 18.9462C12.939 18.1648 12.5 17.105 12.5 16C12.5 14.8949 12.939 13.8351 13.7204 13.0537C14.5018 12.2723 15.5616 11.8333 16.6667 11.8333ZM16.6667 13.5C16.0037 13.5 15.3678 13.7634 14.8989 14.2322C14.4301 14.701 14.1667 15.3369 14.1667 16C14.1667 16.663 14.4301 17.2989 14.8989 17.7677C15.3678 18.2366 16.0037 18.5 16.6667 18.5C17.3297 18.5 17.9656 18.2366 18.4345 17.7677C18.9033 17.2989 19.1667 16.663 19.1667 16C19.1667 15.3369 18.9033 14.701 18.4345 14.2322C17.9656 13.7634 17.3297 13.5 16.6667 13.5Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1262",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#E233FF"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF6B00"
  })))),
  socialmedia: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1270)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1583 17.2583L18.85 20.575M18.8417 11.425L13.1583 14.7416M23.5 10.1666C23.5 11.5473 22.3807 12.6666 21 12.6666C19.6193 12.6666 18.5 11.5473 18.5 10.1666C18.5 8.78591 19.6193 7.66663 21 7.66663C22.3807 7.66663 23.5 8.78591 23.5 10.1666ZM13.5 16C13.5 17.3807 12.3807 18.5 11 18.5C9.61929 18.5 8.5 17.3807 8.5 16C8.5 14.6192 9.61929 13.5 11 13.5C12.3807 13.5 13.5 14.6192 13.5 16ZM23.5 21.8333C23.5 23.214 22.3807 24.3333 21 24.3333C19.6193 24.3333 18.5 23.214 18.5 21.8333C18.5 20.4526 19.6193 19.3333 21 19.3333C22.3807 19.3333 23.5 20.4526 23.5 21.8333Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1270",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#2F80ED"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#B2FFDA"
  })))),
  footersetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1278)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.83337 8.5H8.84171M8.83337 16H8.84171M8.83337 19.75H8.84171M8.83337 12.25H8.84171M12.5834 8.5H12.5917M12.5834 16H12.5917M20.0834 8.5H20.0917M20.0834 16H20.0917M16.3334 8.5H16.3417M16.3334 16H16.3417M16.3334 19.75H16.3417M16.3334 12.25H16.3417M23.8334 8.5H23.8417M23.8334 16H23.8417M23.8334 19.75H23.8417M23.8334 12.25H23.8417M23.8334 23.5H8.83337",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1278",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#DF98FA"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  home: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.5 8.80433C2.5 8.3257 2.5 8.08639 2.56169 7.866C2.61633 7.67078 2.70614 7.48716 2.82669 7.32417C2.96278 7.14017 3.15168 6.99324 3.52949 6.69939L9.18141 2.30345C9.47418 2.07574 9.62057 1.96189 9.78221 1.91812C9.92484 1.87951 10.0752 1.87951 10.2178 1.91812C10.3794 1.96189 10.5258 2.07574 10.8186 2.30345L16.4705 6.69939C16.8483 6.99324 17.0372 7.14017 17.1733 7.32417C17.2939 7.48716 17.3837 7.67078 17.4383 7.866C17.5 8.08639 17.5 8.3257 17.5 8.80433V14.8334C17.5 15.7669 17.5 16.2336 17.3183 16.5901C17.1586 16.9037 16.9036 17.1587 16.59 17.3185C16.2335 17.5001 15.7668 17.5001 14.8333 17.5001H5.16667C4.23325 17.5001 3.76654 17.5001 3.41002 17.3185C3.09641 17.1587 2.84144 16.9037 2.68166 16.5901C2.5 16.2336 2.5 15.7669 2.5 14.8334V8.80433Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })),
  freePro: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_343)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665L13 4.6665C15 -0.583496 20.5833 4.99984 15.3333 6.99984L18.3333 9.99984L15.3333 12.9998C13.3333 7.74984 7.75001 13.3332 13 15.3332L10 18.3332L7 15.3332C5 20.5832 -0.583328 14.9998 4.66667 12.9998L1.66667 9.99984L4.66667 6.99984C6.66667 12.2498 12.25 6.6665 7 4.6665L10 1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_343"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  })))),
  offers: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66667 6.6665H6.67501M1.66667 4.33317L1.66667 8.06193C1.66667 8.46958 1.66667 8.67341 1.71272 8.86522C1.75355 9.03528 1.82089 9.19786 1.91227 9.34698C2.01534 9.51517 2.15947 9.6593 2.44772 9.94755L8.83824 16.3381C9.82829 17.3281 10.3233 17.8231 10.8941 18.0086C11.3962 18.1718 11.9371 18.1718 12.4392 18.0086C13.01 17.8231 13.5051 17.3281 14.4951 16.3381L16.3382 14.4949C17.3283 13.5049 17.8233 13.0099 18.0088 12.439C18.1719 11.9369 18.1719 11.3961 18.0088 10.894C17.8233 10.3231 17.3283 9.82812 16.3382 8.83808L9.94772 2.44755C9.65947 2.1593 9.51534 2.01517 9.34715 1.9121C9.19802 1.82072 9.03545 1.75338 8.86539 1.71255C8.67358 1.6665 8.46975 1.6665 8.0621 1.6665L4.33334 1.6665C3.39992 1.6665 2.93321 1.6665 2.57669 1.84816C2.26308 2.00795 2.00812 2.26292 1.84833 2.57652C1.66667 2.93304 1.66667 3.39975 1.66667 4.33317ZM7.08334 6.6665C7.08334 6.89662 6.89679 7.08317 6.66667 7.08317C6.43655 7.08317 6.25001 6.89662 6.25001 6.6665C6.25001 6.43639 6.43655 6.24984 6.66667 6.24984C6.89679 6.24984 7.08334 6.43639 7.08334 6.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plugins: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M18.7883 4.96168C18.7012 4.87428 18.5977 4.80494 18.4837 4.75762C18.3698 4.7103 18.2476 4.68595 18.1242 4.68595C18.0008 4.68595 17.8787 4.7103 17.7647 4.75762C17.6508 4.80494 17.5473 4.87428 17.4602 4.96168L15 7.42184L12.5781 4.99997L15.0406 2.53825C15.2168 2.36213 15.3157 2.12326 15.3157 1.87418C15.3157 1.62511 15.2168 1.38624 15.0406 1.21012C14.8645 1.034 14.6256 0.935059 14.3766 0.935059C14.1275 0.935059 13.8886 1.034 13.7125 1.21012L11.25 3.67184L9.41329 1.83668C9.32608 1.74948 9.22255 1.6803 9.10861 1.63311C8.99467 1.58591 8.87255 1.56162 8.74922 1.56162C8.50015 1.56162 8.26128 1.66056 8.08516 1.83668C7.90904 2.01281 7.8101 2.25168 7.8101 2.50075C7.8101 2.74982 7.90904 2.98869 8.08516 3.16481L8.35938 3.43747L4.44454 7.35465C4.12528 7.67386 3.87203 8.05283 3.69925 8.46992C3.52647 8.88701 3.43754 9.33405 3.43754 9.78551C3.43754 10.237 3.52647 10.684 3.69925 11.1011C3.87203 11.5182 4.12528 11.8972 4.44454 12.2164L5.45079 13.2226L1.83672 16.8367C1.74952 16.9239 1.68034 17.0274 1.63315 17.1414C1.58595 17.2553 1.56166 17.3774 1.56166 17.5007C1.56166 17.6241 1.58595 17.7462 1.63315 17.8601C1.68034 17.9741 1.74952 18.0776 1.83672 18.1648C2.01284 18.3409 2.25172 18.4399 2.50079 18.4399C2.62411 18.4399 2.74624 18.4156 2.86018 18.3684C2.97412 18.3212 3.07764 18.252 3.16485 18.1648L6.77891 14.5507L7.78516 15.557C8.10437 15.8763 8.48334 16.1295 8.90043 16.3023C9.31752 16.4751 9.76456 16.564 10.216 16.564C10.6675 16.564 11.1145 16.4751 11.5316 16.3023C11.9487 16.1295 12.3277 15.8763 12.6469 15.557L16.5625 11.6406L16.8367 11.9156C16.9239 12.0028 17.0275 12.072 17.1414 12.1192C17.2553 12.1664 17.3775 12.1907 17.5008 12.1907C17.6241 12.1907 17.7462 12.1664 17.8602 12.1192C17.9741 12.072 18.0776 12.0028 18.1648 11.9156C18.2521 11.8284 18.3212 11.7249 18.3684 11.6109C18.4156 11.497 18.4399 11.3749 18.4399 11.2515C18.4399 11.1282 18.4156 11.0061 18.3684 10.8921C18.3212 10.7782 18.2521 10.6747 18.1648 10.5875L16.3281 8.74997L18.7906 6.28825C18.8776 6.20102 18.9466 6.09751 18.9936 5.98361C19.0406 5.86972 19.0646 5.74768 19.0644 5.62448C19.0642 5.50128 19.0397 5.37933 18.9923 5.2656C18.9449 5.15187 18.8756 5.0486 18.7883 4.96168ZM11.3195 14.2297C11.1744 14.3748 11.0022 14.49 10.8125 14.5685C10.6229 14.6471 10.4197 14.6875 10.2145 14.6875C10.0092 14.6875 9.80598 14.6471 9.61637 14.5685C9.42676 14.49 9.25448 14.3748 9.10938 14.2297L5.77032 10.8906C5.62516 10.7455 5.51001 10.5732 5.43145 10.3836C5.35288 10.194 5.31245 9.99076 5.31245 9.78551C5.31245 9.58027 5.35288 9.37704 5.43145 9.18742C5.51001 8.99781 5.62516 8.82553 5.77032 8.68043L9.68751 4.76559L15.2344 10.3125L11.3195 14.2297Z",
    fill: "currentColor"
  })),
  license: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M5.41667 16.6665H4.16667C3.24619 16.6665 2.5 15.9203 2.5 14.9998V3.33317C2.5 2.4127 3.24619 1.6665 4.16667 1.6665H15.8333C16.7538 1.6665 17.5 2.4127 17.5 3.33317V14.9998C17.5 15.9203 16.7538 16.6665 15.8333 16.6665H14.5833M10 15.8332C11.3807 15.8332 12.5 14.7139 12.5 13.3332C12.5 11.9525 11.3807 10.8332 10 10.8332C8.61929 10.8332 7.5 11.9525 7.5 13.3332C7.5 14.7139 8.61929 15.8332 10 15.8332ZM10 15.8332L10.0179 15.833L7.35723 18.4936L5.0002 16.1366L7.51638 13.6204M10 15.8332L12.6607 18.4936L15.0177 16.1366L12.5015 13.6204M7.5 4.99984H12.5M5.83333 7.9165H14.1667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrow: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "13",
    height: "10",
    viewBox: "0 0 13 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.16669 5H11.8334M11.8334 5L7.83335 1M11.8334 5L7.83335 9",
    stroke: "#6266EA",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  youtube: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9.99996 3.3335C10.7125 3.3335 11.4433 3.35183 12.1516 3.38183L12.9883 3.42183L13.7891 3.46933L14.5391 3.52016L15.2241 3.5735C15.9675 3.63039 16.667 3.94762 17.1996 4.46936C17.7321 4.99111 18.0636 5.68395 18.1358 6.426L18.1691 6.78016L18.2316 7.5385C18.29 8.32433 18.3333 9.181 18.3333 10.0002C18.3333 10.8193 18.29 11.676 18.2316 12.4618L18.1691 13.2202C18.1583 13.3418 18.1475 13.4593 18.1358 13.5743C18.0636 14.3165 17.732 15.0095 17.1992 15.5312C16.6665 16.053 15.9668 16.3701 15.2233 16.4268L14.54 16.4793L13.79 16.531L12.9883 16.5785L12.1516 16.6185C11.4348 16.6496 10.7174 16.6658 9.99996 16.6668C9.28248 16.6658 8.5651 16.6496 7.84829 16.6185L7.01163 16.5785L6.21079 16.531L5.46079 16.4793L4.77579 16.4268C4.03242 16.3699 3.33292 16.0527 2.80035 15.531C2.26779 15.0092 1.93627 14.3164 1.86413 13.5743L1.83079 13.2202L1.76829 12.4618C1.70457 11.6428 1.67066 10.8217 1.66663 10.0002C1.66663 9.181 1.70996 8.32433 1.76829 7.5385L1.83079 6.78016C1.84163 6.6585 1.85246 6.541 1.86413 6.426C1.93624 5.68408 2.26764 4.99134 2.80004 4.46962C3.33243 3.94789 4.03173 3.63058 4.77496 3.5735L5.45913 3.52016L6.20913 3.46933L7.01079 3.42183L7.84746 3.38183C8.56454 3.35069 9.2822 3.33458 9.99996 3.3335ZM8.33329 7.97933V12.021C8.33329 12.406 8.74996 12.646 9.08329 12.4543L12.5833 10.4335C12.6595 10.3897 12.7227 10.3265 12.7667 10.2504C12.8107 10.1744 12.8338 10.088 12.8338 10.0002C12.8338 9.91229 12.8107 9.82596 12.7667 9.74988C12.7227 9.67381 12.6595 9.61067 12.5833 9.56683L9.08329 7.54683C9.00726 7.50293 8.92101 7.47983 8.83321 7.47984C8.74542 7.47986 8.65917 7.50299 8.58315 7.54691C8.50713 7.59083 8.44402 7.654 8.40016 7.73005C8.3563 7.8061 8.33324 7.89237 8.33329 7.98016V7.97933Z",
    fill: "currentColor"
  })),
  support: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.33333 6.66853C8.48016 6.25113 8.76998 5.89917 9.15144 5.67498C9.53291 5.45079 9.98141 5.36884 10.4175 5.44364C10.8536 5.51844 11.2492 5.74517 11.5341 6.08367C11.8191 6.42217 11.975 6.8506 11.9744 7.29306C11.9744 8.54213 10.1008 9.16667 10.1008 9.16667M10.1249 11.6667H10.1333M5.83333 15V16.9463C5.83333 17.3903 5.83333 17.6123 5.92436 17.7263C6.00352 17.8255 6.12356 17.8832 6.25045 17.8831C6.39636 17.8829 6.56973 17.7442 6.91646 17.4668L8.90434 15.8765C9.31043 15.5517 9.51347 15.3892 9.73957 15.2737C9.94017 15.1712 10.1537 15.0963 10.3743 15.051C10.6231 15 10.8831 15 11.4031 15H13.5C14.9001 15 15.6002 15 16.135 14.7275C16.6054 14.4878 16.9878 14.1054 17.2275 13.635C17.5 13.1002 17.5 12.4001 17.5 11V6.5C17.5 5.09987 17.5 4.3998 17.2275 3.86502C16.9878 3.39462 16.6054 3.01217 16.135 2.77248C15.6002 2.5 14.9001 2.5 13.5 2.5H6.5C5.09987 2.5 4.3998 2.5 3.86502 2.77248C3.39462 3.01217 3.01217 3.39462 2.77248 3.86502C2.5 4.3998 2.5 5.09987 2.5 6.5V11.6667C2.5 12.4416 2.5 12.8291 2.58519 13.147C2.81635 14.0098 3.49022 14.6836 4.35295 14.9148C4.67087 15 5.05836 15 5.83333 15Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  doc: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.33337 1.6665H10.8334L16.6667 7.49984V18.3332H3.33337V1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.8334 1.6665V7.49984H16.6667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 11.6665H13.3333",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 15H9.99996",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  })),
  lock: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "17",
    height: "21",
    viewBox: "0 0 17 21",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.82456 21C2.29061 21 1.83352 20.8042 1.45329 20.4125C1.07305 20.0208 0.882935 19.55 0.882935 19V9C0.882935 8.45 1.07305 7.97917 1.45329 7.5875C1.83352 7.19583 2.29061 7 2.82456 7H3.79538V5C3.79538 3.61667 4.26865 2.4375 5.21519 1.4625C6.16174 0.4875 7.30649 0 8.64945 0C9.99241 0 11.1372 0.4875 12.0837 1.4625C13.0302 2.4375 13.5035 3.61667 13.5035 5V7H14.4743C15.0083 7 15.4654 7.19583 15.8456 7.5875C16.2258 7.97917 16.416 8.45 16.416 9V19C16.416 19.55 16.2258 20.0208 15.8456 20.4125C15.4654 20.8042 15.0083 21 14.4743 21H2.82456ZM2.82456 19H14.4743V9H2.82456V19ZM8.64945 16C9.1834 16 9.64049 15.8042 10.0207 15.4125C10.401 15.0208 10.5911 14.55 10.5911 14C10.5911 13.45 10.401 12.9792 10.0207 12.5875C9.64049 12.1958 9.1834 12 8.64945 12C8.1155 12 7.65841 12.1958 7.27817 12.5875C6.89794 12.9792 6.70782 13.45 6.70782 14C6.70782 14.55 6.89794 15.0208 7.27817 15.4125C7.65841 15.8042 8.1155 16 8.64945 16ZM5.73701 7H11.5619V5C11.5619 4.16667 11.2787 3.45833 10.7124 2.875C10.1461 2.29167 9.45846 2 8.64945 2C7.84044 2 7.15278 2.29167 6.58647 2.875C6.02016 3.45833 5.73701 4.16667 5.73701 5V7Z",
    fill: "#D9D9D9"
  })),
  documentation: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "20",
    viewBox: "0 0 16 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66671 9.1665H4.66671M6.33337 12.4998H4.66671M11.3334 5.83317H4.66671M14.6667 5.6665V14.3332C14.6667 15.7333 14.6667 16.4334 14.3942 16.9681C14.1545 17.4385 13.7721 17.821 13.3017 18.0607C12.7669 18.3332 12.0668 18.3332 10.6667 18.3332H5.33337C3.93324 18.3332 3.23318 18.3332 2.6984 18.0607C2.22799 17.821 1.84554 17.4385 1.60586 16.9681C1.33337 16.4334 1.33337 15.7333 1.33337 14.3332V5.6665C1.33337 4.26637 1.33337 3.56631 1.60586 3.03153C1.84554 2.56112 2.22799 2.17867 2.6984 1.93899C3.23318 1.6665 3.93324 1.6665 5.33337 1.6665H10.6667C12.0668 1.6665 12.7669 1.6665 13.3017 1.93899C13.7721 2.17867 14.1545 2.56112 14.3942 3.03153C14.6667 3.56631 14.6667 4.26637 14.6667 5.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  supportTwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "18",
    height: "14",
    viewBox: "0 0 18 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.99996 11.1668C9.23607 11.1668 9.43399 11.087 9.59371 10.9272C9.75343 10.7675 9.83329 10.5696 9.83329 10.3335C9.83329 10.0974 9.75343 9.89947 9.59371 9.73975C9.43399 9.58002 9.23607 9.50016 8.99996 9.50016C8.76385 9.50016 8.56593 9.58002 8.40621 9.73975C8.24649 9.89947 8.16662 10.0974 8.16662 10.3335C8.16662 10.5696 8.24649 10.7675 8.40621 10.9272C8.56593 11.087 8.76385 11.1668 8.99996 11.1668ZM8.99996 7.8335C9.23607 7.8335 9.43399 7.75363 9.59371 7.59391C9.75343 7.43419 9.83329 7.23627 9.83329 7.00016C9.83329 6.76405 9.75343 6.56613 9.59371 6.40641C9.43399 6.24669 9.23607 6.16683 8.99996 6.16683C8.76385 6.16683 8.56593 6.24669 8.40621 6.40641C8.24649 6.56613 8.16662 6.76405 8.16662 7.00016C8.16662 7.23627 8.24649 7.43419 8.40621 7.59391C8.56593 7.75363 8.76385 7.8335 8.99996 7.8335ZM8.99996 4.50016C9.23607 4.50016 9.43399 4.4203 9.59371 4.26058C9.75343 4.10086 9.83329 3.90294 9.83329 3.66683C9.83329 3.43072 9.75343 3.2328 9.59371 3.07308C9.43399 2.91336 9.23607 2.8335 8.99996 2.8335C8.76385 2.8335 8.56593 2.91336 8.40621 3.07308C8.24649 3.2328 8.16662 3.43072 8.16662 3.66683C8.16662 3.90294 8.24649 4.10086 8.40621 4.26058C8.56593 4.4203 8.76385 4.50016 8.99996 4.50016ZM15.6666 13.6668H2.33329C1.87496 13.6668 1.4826 13.5036 1.15621 13.1772C0.82982 12.8509 0.666626 12.4585 0.666626 12.0002V8.66683C1.12496 8.66683 1.51732 8.50363 1.84371 8.17725C2.1701 7.85086 2.33329 7.4585 2.33329 7.00016C2.33329 6.54183 2.1701 6.14947 1.84371 5.82308C1.51732 5.49669 1.12496 5.3335 0.666626 5.3335V2.00016C0.666626 1.54183 0.82982 1.14947 1.15621 0.823079C1.4826 0.496691 1.87496 0.333496 2.33329 0.333496H15.6666C16.125 0.333496 16.5173 0.496691 16.8437 0.823079C17.1701 1.14947 17.3333 1.54183 17.3333 2.00016V5.3335C16.875 5.3335 16.4826 5.49669 16.1562 5.82308C15.8298 6.14947 15.6666 6.54183 15.6666 7.00016C15.6666 7.4585 15.8298 7.85086 16.1562 8.17725C16.4826 8.50363 16.875 8.66683 17.3333 8.66683V12.0002C17.3333 12.4585 17.1701 12.8509 16.8437 13.1772C16.5173 13.5036 16.125 13.6668 15.6666 13.6668ZM15.6666 12.0002V9.87516C15.1527 9.56961 14.7465 9.16336 14.4479 8.65641C14.1493 8.14947 14 7.59738 14 7.00016C14 6.40294 14.1493 5.85086 14.4479 5.34391C14.7465 4.83697 15.1527 4.43072 15.6666 4.12516V2.00016H2.33329V4.12516C2.84718 4.43072 3.25343 4.83697 3.55204 5.34391C3.85065 5.85086 3.99996 6.40294 3.99996 7.00016C3.99996 7.59738 3.85065 8.14947 3.55204 8.65641C3.25343 9.16336 2.84718 9.56961 2.33329 9.87516V12.0002H15.6666Z",
    fill: "#5081f5"
  })),
  video: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "22",
    height: "22",
    viewBox: "0 0 22 22",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 21C16.5228 21 21 16.5228 21 11C21 5.47715 16.5228 1 11 1C5.47715 1 1 5.47715 1 11C1 16.5228 5.47715 21 11 21Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.5 7.96533C8.5 7.48805 8.5 7.24941 8.59974 7.11618C8.68666 7.00007 8.81971 6.92744 8.96438 6.9171C9.13038 6.90525 9.33112 7.03429 9.73261 7.29239L14.4532 10.3271C14.8016 10.551 14.9758 10.663 15.0359 10.8054C15.0885 10.9298 15.0885 11.0702 15.0359 11.1946C14.9758 11.337 14.8016 11.449 14.4532 11.6729L9.73261 14.7076C9.33112 14.9657 9.13038 15.0948 8.96438 15.0829C8.81971 15.0726 8.68666 14.9999 8.59974 14.8838C8.5 14.7506 8.5 14.512 8.5 14.0347V7.96533Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrowtwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "8",
    height: "12",
    viewBox: "0 0 8 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.5 11L6.5 6L1.5 1",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  proLogo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "36",
    height: "32",
    viewBox: "0 0 36 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    xlink: "http://www.w3.org/1999/xlink"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "36",
    height: "32",
    fill: "url(#pattern0_2414_1329)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("pattern", {
    id: "pattern0_2414_1329",
    patternContentUnits: "objectBoundingBox",
    width: "1",
    height: "1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("use", {
    href: "#image0_2414_1329",
    transform: "matrix(0.0148148 0 0 0.0166667 -0.0037037 0)"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("image", {
    id: "image0_2414_1329",
    width: "68",
    height: "60",
    href: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEQAAAA8CAMAAADovOwsAAAAV1BMVEXOc5rbY5HlV4roU4foU4foU4foU4foU4foU4foU4fbT4W0THucS3WMVHiETneKY4aDjaKGtb+Izc+IztCIztCIztCIztCIztB/ZYZ8Q26UR3TKT4DnU4fgu8wDAAAAF3RSTlMAECFFeJKvx97w/P399fz4/v7z6D6GwuxpqwkAAAFiSURBVFjDtZeBeoIwDISpIlBwDhCsxb7/c05pxiqMQtPzHuD/kksouST5V6Lr+9u1Vaqpv7+qhzGyyLP0KJLdEv1NvdTUd00aqtK8lKf7OJ0lqGYiWJ0fI8ZkRzZiLIcwuR8jPIixmpKq8TTVtcS46DVRMXK1mN4iVK09qizFnLytqLv2aiBKLviMJ6Vco+xneGoJYDgUhqcb7nZhjGnSxpm02N6PuchceeAZQrtLpWTzZhodoHlDjEIWE2IVMi+FVcjMFUEMpQNFECPC92y5cSm/mzdr2d24/TBn8z4ftiWuKWxL3CFHQP6cvRLkotnOFknLHs4EkYmKhxgMpI33RMYYO0zGQkYMWTbI2kM+QMhTAHmUMM8j5KGG/DIwPy/IbxTzQ4ecFpgjB3JuYQ4/zAmKOYY3U8ryLC/EZwICJqo4oamOCE074tvvnh4+HSRBkXbExIdrJ+Y/c76N+aU/5v8AY+8/zMsnEUwAAAAASUVORK5CYII="
  }))),
  preview: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "14",
    viewBox: "0 0 20 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.01677 7.59415C1.90328 7.41445 1.84654 7.3246 1.81477 7.18602C1.79091 7.08192 1.79091 6.91775 1.81477 6.81366C1.84654 6.67507 1.90328 6.58522 2.01677 6.40552C2.95461 4.92054 5.74617 1.1665 10.0003 1.1665C14.2545 1.1665 17.0461 4.92054 17.9839 6.40552C18.0974 6.58522 18.1541 6.67507 18.1859 6.81366C18.2098 6.91775 18.2098 7.08192 18.1859 7.18602C18.1541 7.3246 18.0974 7.41445 17.9839 7.59415C17.0461 9.07914 14.2545 12.8332 10.0003 12.8332C5.74617 12.8332 2.95461 9.07914 2.01677 7.59415Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 9.49984C11.381 9.49984 12.5003 8.38055 12.5003 6.99984C12.5003 5.61913 11.381 4.49984 10.0003 4.49984C8.61962 4.49984 7.50034 5.61913 7.50034 6.99984C7.50034 8.38055 8.61962 9.49984 10.0003 9.49984Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  hidePassowrd: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.95245 4.2436C9.29113 4.19353 9.64051 4.16667 10.0003 4.16667C14.2545 4.16667 17.0461 7.9207 17.9839 9.40569C18.0974 9.58542 18.1542 9.67528 18.1859 9.81389C18.2098 9.91799 18.2098 10.0822 18.1859 10.1863C18.1541 10.3249 18.097 10.4154 17.9827 10.5963C17.7328 10.9918 17.3518 11.5476 16.8471 12.1504M5.6036 5.59586C3.80187 6.81808 2.57871 8.51615 2.01759 9.4044C1.90357 9.58489 1.84656 9.67514 1.81478 9.81373C1.79091 9.91783 1.7909 10.082 1.81476 10.1861C1.84652 10.3247 1.90328 10.4146 2.01678 10.5943C2.95462 12.0793 5.74618 15.8333 10.0003 15.8333C11.7157 15.8333 13.1932 15.223 14.4074 14.3972M2.50035 2.5L17.5003 17.5M8.23258 8.23223C7.78017 8.68464 7.50035 9.30964 7.50035 10C7.50035 11.3807 8.61964 12.5 10.0003 12.5C10.6907 12.5 11.3157 12.2202 11.7681 11.7678",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  minus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#5081f5",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M12 8V16M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#5081f5",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  pluginList: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.6715 41.615C11.0288 41.2231 11.2158 40.7053 11.1914 40.1756C11.1671 39.6458 10.9333 39.1474 10.5415 38.79C7.15342 35.7059 4.92693 31.5521 4.23437 27.0232C3.54182 22.4943 4.42519 17.8649 6.73675 13.9092C9.04831 9.95354 12.6479 6.91143 16.9336 5.29163C21.2192 3.67182 25.9311 3.57254 30.2812 5.01037C34.6313 6.44821 38.3558 9.33599 40.832 13.1908C43.3081 17.0456 44.3857 21.6336 43.8845 26.1877C43.3834 30.7417 41.3338 34.9857 38.0787 38.2097C34.8235 41.4338 30.5601 43.4426 26.0015 43.9V35.96C28.5768 35.8569 31.0129 34.7635 32.8015 32.9078C34.5902 31.052 35.5932 28.5774 35.6015 26V22C35.6015 21.4696 35.3908 20.9609 35.0157 20.5858C34.6406 20.2107 34.1319 20 33.6015 20H30.0015V14C30.0015 13.4696 29.7908 12.9609 29.4157 12.5858C29.0406 12.2107 28.5319 12 28.0015 12C27.4711 12 26.9623 12.2107 26.5873 12.5858C26.2122 12.9609 26.0015 13.4696 26.0015 14V20H22.0015V14C22.0015 13.4696 21.7908 12.9609 21.4157 12.5858C21.0406 12.2107 20.5319 12 20.0015 12C19.4711 12 18.9623 12.2107 18.5873 12.5858C18.2122 12.9609 18.0015 13.4696 18.0015 14V20H14.4015C13.8711 20 13.3623 20.2107 12.9873 20.5858C12.6122 20.9609 12.4015 21.4696 12.4015 22V26C12.4097 28.5774 13.4128 31.052 15.2014 32.9078C16.9901 34.7635 19.4262 35.8569 22.0015 35.96V46C22.0015 46.5304 22.2122 47.0391 22.5873 47.4142C22.9623 47.7893 23.4711 48 24.0015 48C29.6024 47.9997 35.0269 46.0404 39.3353 42.4616C43.6437 38.8827 46.5648 33.9097 47.5925 28.4039C48.6203 22.8981 47.69 17.2061 44.9628 12.314C42.2356 7.42186 37.8833 3.63762 32.6596 1.61671C27.436 -0.404199 21.67 -0.534496 16.3604 1.24839C11.0508 3.03127 6.53197 6.61504 3.58657 11.379C0.641169 16.1429 -0.545284 21.787 0.232704 27.3337C1.01069 32.8803 3.70412 37.9802 7.84649 41.75C8.23903 42.1067 8.75717 42.2928 9.28694 42.2675C9.81672 42.2422 10.3148 42.0075 10.6715 41.615ZM16.4015 26V24H31.6015V26C31.6015 27.5913 30.9693 29.1174 29.8441 30.2426C28.7189 31.3679 27.1928 32 25.6015 32H22.4015C20.8102 32 19.2841 31.3679 18.1588 30.2426C17.0336 29.1174 16.4015 27.5913 16.4015 26Z",
    fill: "#5081f5"
  })),
  sidebar: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666672",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2820_689)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.1667 8.5V23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8016 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8016 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7665 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67884 22.6054 9.43916 22.135C9.16667 21.6002 9.16667 20.9001 9.16667 19.5V12.5C9.16667 11.0999 9.16667 10.3998 9.43916 9.86502C9.67884 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7665 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2820_689",
    x1: "3.00163",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  star: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "116",
    height: "20",
    viewBox: "0 0 116 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.14319 1.42372C9.53185 0.777902 10.4681 0.777901 10.8568 1.42372L13.0731 5.10651C13.2128 5.33853 13.4405 5.504 13.7043 5.56509L17.8918 6.53491C18.6261 6.70498 18.9154 7.59545 18.4213 8.16466L15.6036 11.4106C15.4261 11.6151 15.3391 11.8828 15.3625 12.1526L15.7342 16.4347C15.7994 17.1857 15.0419 17.736 14.3478 17.442L10.3901 15.7653C10.1408 15.6596 9.85924 15.6596 9.60991 15.7653L5.65216 17.442C4.95813 17.736 4.20065 17.1857 4.26582 16.4347L4.63745 12.1526C4.66087 11.8828 4.57387 11.6151 4.39637 11.4106L1.57871 8.16466C1.0846 7.59545 1.37393 6.70498 2.10824 6.53491L6.29567 5.56509C6.55948 5.504 6.78723 5.33853 6.92685 5.10652L9.14319 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M33.1432 1.42372C33.5319 0.777902 34.4681 0.777901 34.8568 1.42372L37.0731 5.10651C37.2128 5.33853 37.4405 5.504 37.7043 5.56509L41.8918 6.53491C42.6261 6.70498 42.9154 7.59545 42.4213 8.16466L39.6036 11.4106C39.4261 11.6151 39.3391 11.8828 39.3625 12.1526L39.7342 16.4347C39.7994 17.1857 39.0419 17.736 38.3478 17.442L34.3901 15.7653C34.1408 15.6596 33.8592 15.6596 33.6099 15.7653L29.6522 17.442C28.9581 17.736 28.2006 17.1857 28.2658 16.4347L28.6375 12.1526C28.6609 11.8828 28.5739 11.6151 28.3964 11.4106L25.5787 8.16466C25.0846 7.59545 25.3739 6.70498 26.1082 6.53491L30.2957 5.56509C30.5595 5.504 30.7872 5.33853 30.9269 5.10652L33.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M57.1432 1.42372C57.5319 0.777902 58.4681 0.777901 58.8568 1.42372L61.0731 5.10651C61.2128 5.33853 61.4405 5.504 61.7043 5.56509L65.8918 6.53491C66.6261 6.70498 66.9154 7.59545 66.4213 8.16466L63.6036 11.4106C63.4261 11.6151 63.3391 11.8828 63.3625 12.1526L63.7342 16.4347C63.7994 17.1857 63.0419 17.736 62.3478 17.442L58.3901 15.7653C58.1408 15.6596 57.8592 15.6596 57.6099 15.7653L53.6522 17.442C52.9581 17.736 52.2006 17.1857 52.2658 16.4347L52.6375 12.1526C52.6609 11.8828 52.5739 11.6151 52.3964 11.4106L49.5787 8.16466C49.0846 7.59545 49.3739 6.70498 50.1082 6.53491L54.2957 5.56509C54.5595 5.504 54.7872 5.33853 54.9269 5.10652L57.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M81.1432 1.42372C81.5319 0.777902 82.4681 0.777901 82.8568 1.42372L85.0731 5.10651C85.2128 5.33853 85.4405 5.504 85.7043 5.56509L89.8918 6.53491C90.6261 6.70498 90.9154 7.59545 90.4213 8.16466L87.6036 11.4106C87.4261 11.6151 87.3391 11.8828 87.3625 12.1526L87.7342 16.4347C87.7994 17.1857 87.0419 17.736 86.3478 17.442L82.3901 15.7653C82.1408 15.6596 81.8592 15.6596 81.6099 15.7653L77.6522 17.442C76.9581 17.736 76.2006 17.1857 76.2658 16.4347L76.6375 12.1526C76.6609 11.8828 76.5739 11.6151 76.3964 11.4106L73.5787 8.16466C73.0846 7.59545 73.3739 6.70498 74.1082 6.53491L78.2957 5.56509C78.5595 5.504 78.7872 5.33853 78.9269 5.10652L81.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M105.143 1.42372C105.532 0.777902 106.468 0.777901 106.857 1.42372L109.073 5.10651C109.213 5.33853 109.441 5.504 109.704 5.56509L113.892 6.53491C114.626 6.70498 114.915 7.59545 114.421 8.16466L111.604 11.4106C111.426 11.6151 111.339 11.8828 111.363 12.1526L111.734 16.4347C111.799 17.1857 111.042 17.736 110.348 17.442L106.39 15.7653C106.141 15.6596 105.859 15.6596 105.61 15.7653L101.652 17.442C100.958 17.736 100.201 17.1857 100.266 16.4347L100.637 12.1526C100.661 11.8828 100.574 11.6151 100.396 11.4106L97.5787 8.16466C97.0846 7.59545 97.3739 6.70498 98.1082 6.53491L102.296 5.56509C102.559 5.504 102.787 5.33853 102.927 5.10652L105.143 1.42372Z",
    fill: "#F9B83A"
  })),
  review: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.56246 11.8748L9.99996 10.3957L12.4375 11.8748L11.7916 9.104L13.9583 7.229L11.1041 6.99984L9.99996 4.37484L8.89579 6.99984L6.04163 7.229L8.20829 9.104L7.56246 11.8748ZM1.66663 18.3332V3.33317C1.66663 2.87484 1.82996 2.48262 2.15663 2.1565C2.48329 1.83039 2.87551 1.66706 3.33329 1.6665H16.6666C17.125 1.6665 17.5175 1.82984 17.8441 2.1565C18.1708 2.48317 18.3338 2.87539 18.3333 3.33317V13.3332C18.3333 13.7915 18.1702 14.184 17.8441 14.5107C17.518 14.8373 17.1255 15.0004 16.6666 14.9998H4.99996L1.66663 18.3332ZM4.29163 13.3332H16.6666V3.33317H3.33329V14.2707L4.29163 13.3332Z",
    fill: "currentColor"
  }))
};
const Icon = ({
  icon,
  tooltip,
  label
}) => {
  const Icon = icons[icon];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Icon, null), label && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "cwLabel"
  }, label), tooltip && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "cw-tooltip"
  }, tooltip));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);

/***/ },

/***/ "./src/components/Sidebar/index.jsx"
/*!******************************************!*\
  !*** ./src/components/Sidebar/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.jsx");



const Sidebar = ({
  sidebarSettings,
  openInNewTab
}) => {
  const sidebarListing = sidebar => {
    return sidebar.map((sidebaritem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-sidebarbody",
        key: index
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, sidebaritem.heading), sidebaritem.icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: sidebaritem.icon
      })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, sidebaritem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: sidebaritem.buttonUrl,
        target: openInNewTab ? "_blank" : "_self",
        className: "cw-button-btn outline"
      }, sidebaritem.imageurl, sidebaritem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: "arrowtwo"
      }))));
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar-list"
  }, sidebarListing(sidebarSettings))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sidebar);

/***/ },

/***/ "./src/components/Tab/index.jsx"
/*!**************************************!*\
  !*** ./src/components/Tab/index.jsx ***!
  \**************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useTabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useTabs */ "./src/components/Tab/useTabs.jsx");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);





const Tab = ({
  tabsData,
  onChange,
  activeTabTitle
}) => {
  const {
    renderTabs,
    renderContent
  } = (0,_useTabs__WEBPACK_IMPORTED_MODULE_1__["default"])(tabsData, 0, onChange);
  const GetPro = () => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "get-pro"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
      alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'education-zone')
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Education Zone Pro', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get access to all unlimited features.', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "cw-button-btn primary-btn",
      target: "_blank",
      href: cw_dashboard.get_pro
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get Pro', 'education-zone'))));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "top"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "logo"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'education-zone')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, cw_dashboard.blog_name)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-button"
  }, renderTabs())), GetPro())), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_2__.TabHeader, {
    title: activeTabTitle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-content"
  }, renderContent())));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab);

/***/ },

/***/ "./src/components/Tab/useTabs.jsx"
/*!****************************************!*\
  !*** ./src/components/Tab/useTabs.jsx ***!
  \****************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");



function useTabs(initialTabs, initialActiveTab = 0, onChange) {
  const tabsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(initialTabs);
  const [activeTab, setActiveTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialActiveTab);
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useNavigate)();
  const handleTabClick = index => {
    if (index !== activeTab) {
      setActiveTab(index);
      const newHash = tabsRef.current[index].title.toLowerCase().replace(/ /g, "-");
      if (onChange) {
        onChange(tabsRef.current[index].title);
      }
      navigate(`/wp-admin/admin.php?page=education-zone-dashboard#${newHash}`);
    }
  };
  const checkHash = () => {
    const hash = window.location.hash.substring(1);
    const tabIndex = tabsRef.current.findIndex(tab => tab.title.toLowerCase().replace(/ /g, "-") === hash);
    if (tabIndex !== -1 && tabIndex !== activeTab) {
      setActiveTab(tabIndex);
      if (onChange) {
        onChange(tabsRef.current[tabIndex].title);
      }
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkHash();
    window.addEventListener('hashchange', checkHash);
    return () => {
      window.removeEventListener('hashchange', checkHash);
    };
  }, []);
  const renderTabs = () => {
    return tabsRef.current.map((tab, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      key: index,
      onClick: () => handleTabClick(index),
      className: activeTab === index ? 'active-tab' : ''
    }, tab.icon, tab.title));
  };
  const renderContent = () => {
    return tabsRef.current[activeTab].content;
  };
  return {
    renderTabs,
    renderContent
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useTabs);

/***/ },

/***/ "./src/components/TabHeader/index.jsx"
/*!********************************************!*\
  !*** ./src/components/TabHeader/index.jsx ***!
  \********************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const TabHeader = ({
  title
}) => {
  const docLinks = [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Website', 'education-zone'),
    link: cw_dashboard.website,
    icon: "globe"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Tutorials ', 'education-zone'),
    link: cw_dashboard.videotutorial,
    icon: "youtube"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Contact Support', 'education-zone'),
    link: cw_dashboard.support,
    icon: "support"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Docs', 'education-zone'),
    link: cw_dashboard.docmentation,
    icon: "doc"
  }];
  const docLinkListing = () => {
    return docLinks.map((list, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      key: index,
      href: list.link,
      target: "_blank"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: list.icon,
      tooltip: list.name
    })));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "navbar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", null, title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "info"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "version"
  }, cw_dashboard.theme_version), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "doc-links"
  }, docLinkListing()))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TabHeader);

/***/ },

/***/ "./src/components/images.js"
/*!**********************************!*\
  !*** ./src/components/images.js ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   demo2: () => (/* reexport default export from named module */ _assets_img_demo_2_png__WEBPACK_IMPORTED_MODULE_9__),
/* harmony export */   demo3: () => (/* reexport default export from named module */ _assets_img_demo_3_png__WEBPACK_IMPORTED_MODULE_10__),
/* harmony export */   demo4: () => (/* reexport default export from named module */ _assets_img_demo_4_png__WEBPACK_IMPORTED_MODULE_11__),
/* harmony export */   demo5: () => (/* reexport default export from named module */ _assets_img_demo_5_png__WEBPACK_IMPORTED_MODULE_12__),
/* harmony export */   demo6: () => (/* reexport default export from named module */ _assets_img_demo_6_png__WEBPACK_IMPORTED_MODULE_13__),
/* harmony export */   demo7: () => (/* reexport default export from named module */ _assets_img_demo_7_png__WEBPACK_IMPORTED_MODULE_14__),
/* harmony export */   demo8: () => (/* reexport default export from named module */ _assets_img_demo_8_png__WEBPACK_IMPORTED_MODULE_15__),
/* harmony export */   freevspro: () => (/* reexport default export from named module */ _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_0__),
/* harmony export */   gdpr: () => (/* reexport default export from named module */ _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_1__),
/* harmony export */   logo: () => (/* reexport default export from named module */ _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_2__),
/* harmony export */   mainDemo: () => (/* reexport default export from named module */ _assets_img_main_demo_png__WEBPACK_IMPORTED_MODULE_8__),
/* harmony export */   pluginsSetup: () => (/* reexport default export from named module */ _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_3__),
/* harmony export */   seo: () => (/* reexport default export from named module */ _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_4__),
/* harmony export */   themeClub: () => (/* reexport default export from named module */ _assets_img_themeClub_webp__WEBPACK_IMPORTED_MODULE_5__),
/* harmony export */   themeInstallation: () => (/* reexport default export from named module */ _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_6__),
/* harmony export */   vipSupport: () => (/* reexport default export from named module */ _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_7__)
/* harmony export */ });
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../assets/img/GDPR.jpg */ "./src/assets/img/GDPR.jpg");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../assets/img/pluginsSetup.jpg */ "./src/assets/img/pluginsSetup.jpg");
/* harmony import */ var _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../assets/img/SEO.jpg */ "./src/assets/img/SEO.jpg");
/* harmony import */ var _assets_img_themeClub_webp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../assets/img/themeClub.webp */ "./src/assets/img/themeClub.webp");
/* harmony import */ var _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../assets/img/themeInstallation.jpg */ "./src/assets/img/themeInstallation.jpg");
/* harmony import */ var _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../assets/img/vipSupport.jpg */ "./src/assets/img/vipSupport.jpg");
/* harmony import */ var _assets_img_main_demo_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../assets/img/main-demo.png */ "./src/assets/img/main-demo.png");
/* harmony import */ var _assets_img_demo_2_png__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../assets/img/demo-2.png */ "./src/assets/img/demo-2.png");
/* harmony import */ var _assets_img_demo_3_png__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../assets/img/demo-3.png */ "./src/assets/img/demo-3.png");
/* harmony import */ var _assets_img_demo_4_png__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../assets/img/demo-4.png */ "./src/assets/img/demo-4.png");
/* harmony import */ var _assets_img_demo_5_png__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../assets/img/demo-5.png */ "./src/assets/img/demo-5.png");
/* harmony import */ var _assets_img_demo_6_png__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../assets/img/demo-6.png */ "./src/assets/img/demo-6.png");
/* harmony import */ var _assets_img_demo_7_png__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../assets/img/demo-7.png */ "./src/assets/img/demo-7.png");
/* harmony import */ var _assets_img_demo_8_png__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../assets/img/demo-8.png */ "./src/assets/img/demo-8.png");

















/***/ },

/***/ "./src/components/index.js"
/*!*********************************!*\
  !*** ./src/components/index.js ***!
  \*********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: () => (/* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   Heading: () => (/* reexport safe */ _Heading__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   Icon: () => (/* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Sidebar: () => (/* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Tab: () => (/* reexport safe */ _Tab__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   TabHeader: () => (/* reexport safe */ _TabHeader__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon */ "./src/components/Icon/index.jsx");
/* harmony import */ var _Tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tab */ "./src/components/Tab/index.jsx");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Sidebar */ "./src/components/Sidebar/index.jsx");
/* harmony import */ var _TabHeader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TabHeader */ "./src/components/TabHeader/index.jsx");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Card */ "./src/components/Card/index.jsx");
/* harmony import */ var _Heading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Heading */ "./src/components/Heading/index.jsx");







/***/ },

/***/ "./src/pages/FAQ/index.jsx"
/*!*********************************!*\
  !*** ./src/pages/FAQ/index.jsx ***!
  \*********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");




function FAQ() {
  const faqContent = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What is the difference between Free and Pro?', 'education-zone'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Both the Free and Pro version of the themes are coded well and are developed with best coding practices. However, the Pro version of the theme comes with extended features and dedicated support team to help you solve your queries. The Pro theme comes with multiple layouts to help you create a unique and attractive website. Also, the Pro themes are fully compatible with Polylang and WPML plugin to help you create a multilingual blog and get wide reach.')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Overall, you will have more control over the customization and editing of your website with the Pro version.', 'education-zone')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What are the perks of upgrading to the Premium version?', 'education-zone'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Along with the additional features and regular updates, you get dedicated and quick support with the premium theme. If you run into any issue while creating a website with the premium theme, you will get a quicker response compared to the free support.', 'education-zone')
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Upgrading to the Pro version- will I lose my changes?', 'education-zone'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you upgrade to the Pro theme, your posts, pages, media, categories, and other data will remain intact-- all your data is saved.', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('However, since the Pro version comes with added features and settings, you will need to set up the additional features in the customizer. This process is simple and only takes a few minutes.', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The Pro version is built with lots of flexibility in mind for future upgrades. Therefore, it is slightly different than the free theme but extremely flexible and easy-to-use.', 'education-zone')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How do I change the copyright text?', 'education-zone'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You can change the copyright text going to %1$s Appearance > Customize > Footer Settings. %2$s However, if you want to hide the author credit text, please %3$s.', 'education-zone'), '<b>', '</b>', `<a target="_blank" href=${cw_dashboard.get_pro}>upgrade to the Pro version</a>`)
      }
    })
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Why is my theme not working well?', 'education-zone'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If your customizer is not loading properly or you are having issues with the theme, it might be due to the plugin conflict.', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To solve the issue, deactivate all the plugins first, except the ones recommended by the theme. Then, hard reload your website using %1$s "Ctrl+Shift+R" %2$s on Windows and %1$s "Cmd+Shift+R" %2$s on Mac. If the issues are fixed, start activating the plugins one by one, and reload and check your site each time. This will help you find out the plugin that is causing the problem.', 'education-zone'), '<b>', '</b>')
      }
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If this didn\'t help, please contact us via our %s.', 'education-zone'), `<a target="_blank" href=${cw_dashboard.support}>Support Ticket.</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How can I solve my issues quickly and get faster support?', 'education-zone'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Please ensure that you have updated to the latest version of the theme before you submit a support ticket for any issue. We might have already fixed the bug in the previous theme update.', 'education-zone')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Also, when you submit the support ticket, please try to provide maximum details so that we can look into your issue in detail and solve it in minimum time. We recommend you to send us a screenshot(s) with issues explained and your website\'s address (URL). You can contact us ', 'education-zone'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: cw_dashboard.support,
      target: "_blank"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('here.', 'education-zone'))))
  }];
  const [openIndex, setOpenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [height, setHeight] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('0px');
  const contentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setHeight(openIndex !== -1 ? `${contentRef.current.scrollHeight}px` : '0px');
  }, [openIndex]);
  const toggleDescription = index => {
    setOpenIndex(index === openIndex ? -1 : index);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, faqContent.map((content, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-item",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-title",
    onClick: () => toggleDescription(index)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, content.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: openIndex === index ? 'minus' : 'plus'
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-description",
    ref: openIndex === index ? contentRef : null,
    style: {
      maxHeight: openIndex === index ? height : '0px',
      overflow: 'hidden',
      transition: 'max-height 0.5s ease'
    }
  }, typeof content.description === 'string' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, content.description) : content.description))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FAQ);

/***/ },

/***/ "./src/pages/FreePro/index.jsx"
/*!*************************************!*\
  !*** ./src/pages/FreePro/index.jsx ***!
  \*************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const FreePro = () => {
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('We Value Your Feedback!', 'education-zone'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Leave a Review', 'education-zone'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Explore', 'education-zone'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Need Assistance? ', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Submit a Ticket', 'education-zone'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "freepro",
    src: _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Free vs Pro image", "education-zone")
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FreePro);

/***/ },

/***/ "./src/pages/Home/index.jsx"
/*!**********************************!*\
  !*** ./src/pages/Home/index.jsx ***!
  \**********************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const Homepage = () => {
  const cardLists = [{
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "site"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Site Identity', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.custom_logo
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "colorsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Color Settings", 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.colors
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "layoutsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Layout Settings", 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.layout
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "frontpagesetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Front Page Settings", 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.frontpage
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "generalsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("General Settings"),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.general
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "footersetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Footer Settings', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'education-zone'),
    buttonUrl: cw_dashboard.footer
  }];
  const proSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Header Layouts', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose from different unique header layouts.', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'education-zone'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Layouts', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose layouts for blogs, banners, posts and more.', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'education-zone'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Sidebar', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set different sidebars for posts and pages.', 'education-zone'),
    buttonText: "Learn More",
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Boost your website performance with ease.', 'education-zone'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Performance Settings', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'education-zone'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose typography for different heading tags.', 'education-zone'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Typography Settings', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'education-zone'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import the demo content to kickstart your site.', 'education-zone'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'education-zone'),
    buttonUrl: cw_dashboard?.get_pro
  }];
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('We Value Your Feedback!', 'education-zone'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Leave a Review', 'education-zone'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Knowledge Base', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Explore', 'education-zone'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Need Assistance? ', 'education-zone'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'education-zone'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Submit a Ticket', 'education-zone'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quick Customizer Settings', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'education-zone'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: cardLists,
    cardPlace: "customizer",
    cardCol: "three-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('More features with Pro version', 'education-zone'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'education-zone'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: proSettings,
    cardPlace: "cw-pro",
    cardCol: "two-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard?.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn long-button"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn more about the Pro version', 'education-zone')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Homepage);

/***/ },

/***/ "./src/pages/Offers/index.jsx"
/*!************************************!*\
  !*** ./src/pages/Offers/index.jsx ***!
  \************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");



const Offers = () => {
  const offerBannerLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeClub,
    imageUrl: cw_dashboard.theme_club_upgrade,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Club", "education-zone")
  }];
  const offerCardLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeInstallation,
    imageUrl: cw_dashboard.theme_install,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Installation & Setup", "education-zone")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.gdpr,
    imageUrl: cw_dashboard.gdpr_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("GDPR Compliance", "education-zone")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.seo,
    imageUrl: cw_dashboard.seo_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have SEO Setup", "education-zone")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.pluginsSetup,
    imageUrl: cw_dashboard.plugin_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have Plugins Setup", "education-zone")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSupport,
    imageUrl: cw_dashboard.vip_support,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Support", "education-zone")
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-offer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "banner-section"
  }, offerBannerLists.map((banner, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: banner.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: banner.image,
    alt: banner.title
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "card-section"
  }, offerCardLists.map((card, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: card.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: card.image,
    alt: card.title
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Offers);

/***/ },

/***/ "./src/pages/StarterSites/index.jsx"
/*!******************************************!*\
  !*** ./src/pages/StarterSites/index.jsx ***!
  \******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");




const StarterSites = () => {
  const starterCardSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Education Zone Pro', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.mainDemo,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Education Zone Pro Modern', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo2,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-modern/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Smart Education', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo3,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-2/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('High School', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo4,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-3/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Pre School', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo5,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-4/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('University', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo6,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-5/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Kidspace', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo7,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-6/"
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Tutor', 'education-zone'),
    imageurl: _components_images__WEBPACK_IMPORTED_MODULE_3__.demo8,
    buttonUrl: "https://rarathemesdemo.com/education-zone-pro-7/"
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Card, {
    cardList: starterCardSettings,
    cardPlace: "starter",
    cardCol: "three-col"
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StarterSites);

/***/ },

/***/ "./src/pages/UsefulPlugins/index.jsx"
/*!*******************************************!*\
  !*** ./src/pages/UsefulPlugins/index.jsx ***!
  \*******************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const pluginList = [{
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('RaraTheme Companion', 'education-zone'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("23 extremely useful custom widgets to create an engaging website.", "education-zone"),
  slug: "raratheme-companion"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Contact Form 7', 'education-zone'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Just another contact form plugin. Simple but flexible.", "education-zone"),
  slug: "contact-form-7"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Rara One Click Demo Import', 'education-zone'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Make your website look like the live demo of the theme with a click!", "education-zone"),
  slug: "rara-one-click-demo-import"
}];
const objectExistsInArray = (obj, array) => {
  return array.some(el => el.slug === obj.slug);
};
const UsefulPlugins = () => {
  const [buttonState, setButtonState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(() => {
    const initialState = {};
    pluginList.forEach(plugin => {
      initialState[plugin.slug] = 'Install';
    });
    return initialState;
  });
  const [activateUrls, setActivateUrls] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const activePlugins = cw_dashboard.activePlugins;
    const inactivePlugins = cw_dashboard.inactivePlugins;
    const newButtonState = {};

    // Set state for active plugins
    activePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activated';
      }
    });

    // Set state for inactive plugins
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activate';
      }
    });
    setButtonState(prevState => ({
      ...prevState,
      ...newButtonState
    }));
    const urls = {};
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        const url = plugin.url.replace(/&amp;/g, '&');
        urls[plugin.slug] = url;
      }
    });
    setActivateUrls(urls);
  }, []);
  const installPlugin = slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Installing...'
    }));
    wp.updates.installPlugin({
      slug: slug,
      success: response => {
        setActivateUrls(prevUrls => ({
          ...prevUrls,
          [slug]: response.activateUrl
        }));
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      },
      error: error => {
        console.error(error);
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Install'
        }));
      }
    });
  };
  const activatePlugin = async slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Activating...'
    }));
    const url = activateUrls[slug];
    if (url) {
      try {
        const response = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: new URLSearchParams({
            _wpnonce: new URL(url).searchParams.get('_wpnonce'),
            action: 'activate',
            plugin: new URL(url).searchParams.get('plugin')
          }).toString()
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activated'
        }));
      } catch (error) {
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      }
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list-wrapper"
  }, pluginList.map((plugin, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "plugin-detail"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-title"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "pluginList",
    label: plugin.pluginName
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "description"
  }, plugin.description)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "insert-button"
  }, buttonState[plugin.slug] === 'Install' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => installPlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Install', 'education-zone')), buttonState[plugin.slug] === 'Installing...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Installing...', 'education-zone')), buttonState[plugin.slug] === 'Activate' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => activatePlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activate', 'education-zone')), buttonState[plugin.slug] === 'Activating...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activating...', 'education-zone')), buttonState[plugin.slug] === 'Activated' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn primary-btn deactivate",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activated', 'education-zone'))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UsefulPlugins);

/***/ },

/***/ "./src/pages/index.js"
/*!****************************!*\
  !*** ./src/pages/index.js ***!
  \****************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components */ "./src/components/index.js");
/* harmony import */ var _FreePro__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FreePro */ "./src/pages/FreePro/index.jsx");
/* harmony import */ var _Home__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Home */ "./src/pages/Home/index.jsx");
/* harmony import */ var _Offers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Offers */ "./src/pages/Offers/index.jsx");
/* harmony import */ var _UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./UsefulPlugins */ "./src/pages/UsefulPlugins/index.jsx");
/* harmony import */ var _FAQ__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FAQ */ "./src/pages/FAQ/index.jsx");
/* harmony import */ var _StarterSites__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StarterSites */ "./src/pages/StarterSites/index.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__);










function Dashboard() {
  const [activeTabTitle, setActiveTabTitle] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Home');
  const tabsData = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Home', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "home"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Home__WEBPACK_IMPORTED_MODULE_3__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Starter Sites', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "globe"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_StarterSites__WEBPACK_IMPORTED_MODULE_7__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Free vs Pro', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "freePro"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FreePro__WEBPACK_IMPORTED_MODULE_2__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Offers', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "offers"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Offers__WEBPACK_IMPORTED_MODULE_4__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('FAQs', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "support"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FAQ__WEBPACK_IMPORTED_MODULE_6__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Useful Plugins', 'education-zone'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "plugins"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__["default"], null)
  }];
  const handleTabChange = title => {
    setActiveTabTitle(title);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
    tabsData: tabsData,
    onChange: handleTabChange,
    activeTabTitle: activeTabTitle
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashboard);

/***/ },

/***/ "./src/scss/style.scss"
/*!*****************************!*\
  !*** ./src/scss/style.scss ***!
  \*****************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ },

/***/ "./node_modules/react-router-dom/dist/index.js"
/*!*****************************************************!*\
  !*** ./node_modules/react-router-dom/dist/index.js ***!
  \*****************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.AbortedDeferredError),
/* harmony export */   Await: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Await),
/* harmony export */   BrowserRouter: () => (/* binding */ BrowserRouter),
/* harmony export */   Form: () => (/* binding */ Form),
/* harmony export */   HashRouter: () => (/* binding */ HashRouter),
/* harmony export */   Link: () => (/* binding */ Link),
/* harmony export */   MemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.MemoryRouter),
/* harmony export */   NavLink: () => (/* binding */ NavLink),
/* harmony export */   Navigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Action),
/* harmony export */   Outlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Outlet),
/* harmony export */   Route: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Route),
/* harmony export */   Router: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Routes),
/* harmony export */   ScrollRestoration: () => (/* binding */ ScrollRestoration),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_ErrorResponseImpl),
/* harmony export */   UNSAFE_FetchersContext: () => (/* binding */ FetchersContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext),
/* harmony export */   UNSAFE_ViewTransitionContext: () => (/* binding */ ViewTransitionContext),
/* harmony export */   UNSAFE_useRouteId: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRouteId),
/* harmony export */   UNSAFE_useScrollRestoration: () => (/* binding */ useScrollRestoration),
/* harmony export */   createBrowserRouter: () => (/* binding */ createBrowserRouter),
/* harmony export */   createHashRouter: () => (/* binding */ createHashRouter),
/* harmony export */   createMemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createRoutesFromElements),
/* harmony export */   createSearchParams: () => (/* binding */ createSearchParams),
/* harmony export */   defer: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.redirectDocument),
/* harmony export */   renderMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.resolvePath),
/* harmony export */   unstable_HistoryRouter: () => (/* binding */ HistoryRouter),
/* harmony export */   unstable_usePrompt: () => (/* binding */ usePrompt),
/* harmony export */   useActionData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useActionData),
/* harmony export */   useAsyncError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useAsyncError),
/* harmony export */   useAsyncValue: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useAsyncValue),
/* harmony export */   useBeforeUnload: () => (/* binding */ useBeforeUnload),
/* harmony export */   useBlocker: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useBlocker),
/* harmony export */   useFetcher: () => (/* binding */ useFetcher),
/* harmony export */   useFetchers: () => (/* binding */ useFetchers),
/* harmony export */   useFormAction: () => (/* binding */ useFormAction),
/* harmony export */   useHref: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useHref),
/* harmony export */   useInRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useInRouterContext),
/* harmony export */   useLinkClickHandler: () => (/* binding */ useLinkClickHandler),
/* harmony export */   useLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useLoaderData),
/* harmony export */   useLocation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation),
/* harmony export */   useMatch: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useMatch),
/* harmony export */   useMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useMatches),
/* harmony export */   useNavigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate),
/* harmony export */   useNavigation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigation),
/* harmony export */   useNavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigationType),
/* harmony export */   useOutlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useOutlet),
/* harmony export */   useOutletContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useOutletContext),
/* harmony export */   useParams: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useParams),
/* harmony export */   useResolvedPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath),
/* harmony export */   useRevalidator: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRevalidator),
/* harmony export */   useRouteError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.useRoutes),
/* harmony export */   useSearchParams: () => (/* binding */ useSearchParams),
/* harmony export */   useSubmit: () => (/* binding */ useSubmit),
/* harmony export */   useViewTransitionState: () => (/* binding */ useViewTransitionState)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router DOM v6.30.3
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */







function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

const defaultMethod = "get";
const defaultEncType = "application/x-www-form-urlencoded";
function isHtmlElement(object) {
  return object != null && typeof object.tagName === "string";
}
function isButtonElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "button";
}
function isFormElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "form";
}
function isInputElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "input";
}
function isModifiedEvent(event) {
  return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}
function shouldProcessLinkClick(event, target) {
  return event.button === 0 && (
  // Ignore everything but left clicks
  !target || target === "_self") &&
  // Let browser handle "target=_blank" etc.
  !isModifiedEvent(event) // Ignore clicks with modifier keys
  ;
}
/**
 * Creates a URLSearchParams object using the given initializer.
 *
 * This is identical to `new URLSearchParams(init)` except it also
 * supports arrays as values in the object form of the initializer
 * instead of just strings. This is convenient when you need multiple
 * values for a given key, but don't want to use an array initializer.
 *
 * For example, instead of:
 *
 *   let searchParams = new URLSearchParams([
 *     ['sort', 'name'],
 *     ['sort', 'price']
 *   ]);
 *
 * you can do:
 *
 *   let searchParams = createSearchParams({
 *     sort: ['name', 'price']
 *   });
 */
function createSearchParams(init) {
  if (init === void 0) {
    init = "";
  }
  return new URLSearchParams(typeof init === "string" || Array.isArray(init) || init instanceof URLSearchParams ? init : Object.keys(init).reduce((memo, key) => {
    let value = init[key];
    return memo.concat(Array.isArray(value) ? value.map(v => [key, v]) : [[key, value]]);
  }, []));
}
function getSearchParamsForLocation(locationSearch, defaultSearchParams) {
  let searchParams = createSearchParams(locationSearch);
  if (defaultSearchParams) {
    // Use `defaultSearchParams.forEach(...)` here instead of iterating of
    // `defaultSearchParams.keys()` to work-around a bug in Firefox related to
    // web extensions. Relevant Bugzilla tickets:
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1414602
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1023984
    defaultSearchParams.forEach((_, key) => {
      if (!searchParams.has(key)) {
        defaultSearchParams.getAll(key).forEach(value => {
          searchParams.append(key, value);
        });
      }
    });
  }
  return searchParams;
}
// One-time check for submitter support
let _formDataSupportsSubmitter = null;
function isFormDataSubmitterSupported() {
  if (_formDataSupportsSubmitter === null) {
    try {
      new FormData(document.createElement("form"),
      // @ts-expect-error if FormData supports the submitter parameter, this will throw
      0);
      _formDataSupportsSubmitter = false;
    } catch (e) {
      _formDataSupportsSubmitter = true;
    }
  }
  return _formDataSupportsSubmitter;
}
const supportedFormEncTypes = new Set(["application/x-www-form-urlencoded", "multipart/form-data", "text/plain"]);
function getFormEncType(encType) {
  if (encType != null && !supportedFormEncTypes.has(encType)) {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "\"" + encType + "\" is not a valid `encType` for `<Form>`/`<fetcher.Form>` " + ("and will default to \"" + defaultEncType + "\"")) : 0;
    return null;
  }
  return encType;
}
function getFormSubmissionInfo(target, basename) {
  let method;
  let action;
  let encType;
  let formData;
  let body;
  if (isFormElement(target)) {
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("enctype")) || defaultEncType;
    formData = new FormData(target);
  } else if (isButtonElement(target) || isInputElement(target) && (target.type === "submit" || target.type === "image")) {
    let form = target.form;
    if (form == null) {
      throw new Error("Cannot submit a <button> or <input type=\"submit\"> without a <form>");
    }
    // <button>/<input type="submit"> may override attributes of <form>
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("formaction") || form.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("formmethod") || form.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("formenctype")) || getFormEncType(form.getAttribute("enctype")) || defaultEncType;
    // Build a FormData object populated from a form and submitter
    formData = new FormData(form, target);
    // If this browser doesn't support the `FormData(el, submitter)` format,
    // then tack on the submitter value at the end.  This is a lightweight
    // solution that is not 100% spec compliant.  For complete support in older
    // browsers, consider using the `formdata-submitter-polyfill` package
    if (!isFormDataSubmitterSupported()) {
      let {
        name,
        type,
        value
      } = target;
      if (type === "image") {
        let prefix = name ? name + "." : "";
        formData.append(prefix + "x", "0");
        formData.append(prefix + "y", "0");
      } else if (name) {
        formData.append(name, value);
      }
    }
  } else if (isHtmlElement(target)) {
    throw new Error("Cannot submit element that is not <form>, <button>, or " + "<input type=\"submit|image\">");
  } else {
    method = defaultMethod;
    action = null;
    encType = defaultEncType;
    body = target;
  }
  // Send body for <Form encType="text/plain" so we encode it into text
  if (formData && encType === "text/plain") {
    body = formData;
    formData = undefined;
  }
  return {
    action,
    method: method.toLowerCase(),
    encType,
    formData,
    body
  };
}

const _excluded = ["onClick", "relative", "reloadDocument", "replace", "state", "target", "to", "preventScrollReset", "viewTransition"],
  _excluded2 = ["aria-current", "caseSensitive", "className", "end", "style", "to", "viewTransition", "children"],
  _excluded3 = ["fetcherKey", "navigate", "reloadDocument", "replace", "state", "method", "action", "onSubmit", "relative", "preventScrollReset", "viewTransition"];
// HEY YOU! DON'T TOUCH THIS VARIABLE!
//
// It is replaced with the proper version at build time via a babel plugin in
// the rollup config.
//
// Export a global property onto the window for React Router detection by the
// Core Web Vitals Technology Report.  This way they can configure the `wappalyzer`
// to detect and properly classify live websites as being built with React Router:
// https://github.com/HTTPArchive/wappalyzer/blob/main/src/technologies/r.json
const REACT_ROUTER_VERSION = "6";
try {
  window.__reactRouterVersion = REACT_ROUTER_VERSION;
} catch (e) {
  // no-op
}
function createBrowserRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createBrowserHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function createHashRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createHashHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function parseHydrationData() {
  var _window;
  let state = (_window = window) == null ? void 0 : _window.__staticRouterHydrationData;
  if (state && state.errors) {
    state = _extends({}, state, {
      errors: deserializeErrors(state.errors)
    });
  }
  return state;
}
function deserializeErrors(errors) {
  if (!errors) return null;
  let entries = Object.entries(errors);
  let serialized = {};
  for (let [key, val] of entries) {
    // Hey you!  If you change this, please change the corresponding logic in
    // serializeErrors in react-router-dom/server.tsx :)
    if (val && val.__type === "RouteErrorResponse") {
      serialized[key] = new react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_ErrorResponseImpl(val.status, val.statusText, val.data, val.internal === true);
    } else if (val && val.__type === "Error") {
      // Attempt to reconstruct the right type of Error (i.e., ReferenceError)
      if (val.__subType) {
        let ErrorConstructor = window[val.__subType];
        if (typeof ErrorConstructor === "function") {
          try {
            // @ts-expect-error
            let error = new ErrorConstructor(val.message);
            // Wipe away the client-side stack trace.  Nothing to fill it in with
            // because we don't serialize SSR stack traces for security reasons
            error.stack = "";
            serialized[key] = error;
          } catch (e) {
            // no-op - fall through and create a normal Error
          }
        }
      }
      if (serialized[key] == null) {
        let error = new Error(val.message);
        // Wipe away the client-side stack trace.  Nothing to fill it in with
        // because we don't serialize SSR stack traces for security reasons
        error.stack = "";
        serialized[key] = error;
      }
    } else {
      serialized[key] = val;
    }
  }
  return serialized;
}
const ViewTransitionContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  isTransitioning: false
});
if (true) {
  ViewTransitionContext.displayName = "ViewTransition";
}
const FetchersContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(new Map());
if (true) {
  FetchersContext.displayName = "Fetchers";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Components
////////////////////////////////////////////////////////////////////////////////
/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];
const FLUSH_SYNC = "flushSync";
const flushSyncImpl = react_dom__WEBPACK_IMPORTED_MODULE_1__[FLUSH_SYNC];
const USE_ID = "useId";
const useIdImpl = react__WEBPACK_IMPORTED_MODULE_0__[USE_ID];
function startTransitionSafe(cb) {
  if (startTransitionImpl) {
    startTransitionImpl(cb);
  } else {
    cb();
  }
}
function flushSyncSafe(cb) {
  if (flushSyncImpl) {
    flushSyncImpl(cb);
  } else {
    cb();
  }
}
class Deferred {
  constructor() {
    this.status = "pending";
    this.promise = new Promise((resolve, reject) => {
      this.resolve = value => {
        if (this.status === "pending") {
          this.status = "resolved";
          resolve(value);
        }
      };
      this.reject = reason => {
        if (this.status === "pending") {
          this.status = "rejected";
          reject(reason);
        }
      };
    });
  }
}
/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let [pendingState, setPendingState] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [vtContext, setVtContext] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    isTransitioning: false
  });
  let [renderDfd, setRenderDfd] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [transition, setTransition] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [interruption, setInterruption] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useRef(new Map());
  let {
    v7_startTransition
  } = future || {};
  let optInStartTransition = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(cb => {
    if (v7_startTransition) {
      startTransitionSafe(cb);
    } else {
      cb();
    }
  }, [v7_startTransition]);
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((newState, _ref2) => {
    let {
      deletedFetchers,
      flushSync: flushSync,
      viewTransitionOpts: viewTransitionOpts
    } = _ref2;
    newState.fetchers.forEach((fetcher, key) => {
      if (fetcher.data !== undefined) {
        fetcherData.current.set(key, fetcher.data);
      }
    });
    deletedFetchers.forEach(key => fetcherData.current.delete(key));
    let isViewTransitionUnavailable = router.window == null || router.window.document == null || typeof router.window.document.startViewTransition !== "function";
    // If this isn't a view transition or it's not available in this browser,
    // just update and be done with it
    if (!viewTransitionOpts || isViewTransitionUnavailable) {
      if (flushSync) {
        flushSyncSafe(() => setStateImpl(newState));
      } else {
        optInStartTransition(() => setStateImpl(newState));
      }
      return;
    }
    // flushSync + startViewTransition
    if (flushSync) {
      // Flush through the context to mark DOM elements as transition=ing
      flushSyncSafe(() => {
        // Cancel any pending transitions
        if (transition) {
          renderDfd && renderDfd.resolve();
          transition.skipTransition();
        }
        setVtContext({
          isTransitioning: true,
          flushSync: true,
          currentLocation: viewTransitionOpts.currentLocation,
          nextLocation: viewTransitionOpts.nextLocation
        });
      });
      // Update the DOM
      let t = router.window.document.startViewTransition(() => {
        flushSyncSafe(() => setStateImpl(newState));
      });
      // Clean up after the animation completes
      t.finished.finally(() => {
        flushSyncSafe(() => {
          setRenderDfd(undefined);
          setTransition(undefined);
          setPendingState(undefined);
          setVtContext({
            isTransitioning: false
          });
        });
      });
      flushSyncSafe(() => setTransition(t));
      return;
    }
    // startTransition + startViewTransition
    if (transition) {
      // Interrupting an in-progress transition, cancel and let everything flush
      // out, and then kick off a new transition from the interruption state
      renderDfd && renderDfd.resolve();
      transition.skipTransition();
      setInterruption({
        state: newState,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    } else {
      // Completed navigation update with opted-in view transitions, let 'er rip
      setPendingState(newState);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    }
  }, [router.window, transition, renderDfd, fetcherData, optInStartTransition]);
  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  // When we start a view transition, create a Deferred we can use for the
  // eventual "completed" render
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (vtContext.isTransitioning && !vtContext.flushSync) {
      setRenderDfd(new Deferred());
    }
  }, [vtContext]);
  // Once the deferred is created, kick off startViewTransition() to update the
  // DOM and then wait on the Deferred to resolve (indicating the DOM update has
  // happened)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && router.window) {
      let newState = pendingState;
      let renderPromise = renderDfd.promise;
      let transition = router.window.document.startViewTransition(async () => {
        optInStartTransition(() => setStateImpl(newState));
        await renderPromise;
      });
      transition.finished.finally(() => {
        setRenderDfd(undefined);
        setTransition(undefined);
        setPendingState(undefined);
        setVtContext({
          isTransitioning: false
        });
      });
      setTransition(transition);
    }
  }, [optInStartTransition, pendingState, renderDfd, router.window]);
  // When the new location finally renders and is committed to the DOM, this
  // effect will run to resolve the transition
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && state.location.key === pendingState.location.key) {
      renderDfd.resolve();
    }
  }, [renderDfd, transition, state.location, pendingState]);
  // If we get interrupted with a new navigation during a transition, we skip
  // the active transition, let it cleanup, then kick it off again here
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!vtContext.isTransitioning && interruption) {
      setPendingState(interruption.state);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: interruption.currentLocation,
        nextLocation: interruption.nextLocation
      });
      setInterruption(undefined);
    }
  }, [vtContext.isTransitioning, interruption]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  let routerFuture = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    v7_relativeSplatPath: router.future.v7_relativeSplatPath
  }), [router.future.v7_relativeSplatPath]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future, router.future), [future, router.future]);
  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FetchersContext.Provider, {
    value: fetcherData.current
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ViewTransitionContext.Provider, {
    value: vtContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: routerFuture
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(MemoizedDataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))))), null);
}
// Memoize to avoid re-renders when updating `ViewTransitionContext`
const MemoizedDataRoutes = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.memo(DataRoutes);
function DataRoutes(_ref3) {
  let {
    routes,
    future,
    state
  } = _ref3;
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRoutesImpl)(routes, undefined, state, future);
}
/**
 * A `<Router>` for use in web browsers. Provides the cleanest URLs.
 */
function BrowserRouter(_ref4) {
  let {
    basename,
    children,
    future,
    window
  } = _ref4;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createBrowserHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` for use in web browsers. Stores the location in the hash
 * portion of the URL so it is not sent to the server.
 */
function HashRouter(_ref5) {
  let {
    basename,
    children,
    future,
    window
  } = _ref5;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createHashHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` that accepts a pre-instantiated history object. It's important
 * to note that using your own history object is highly discouraged and may add
 * two versions of the history library to your bundles unless you use the same
 * version of the history library that React Router uses internally.
 */
function HistoryRouter(_ref6) {
  let {
    basename,
    children,
    future,
    history
  } = _ref6;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_logV6DeprecationWarnings)(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_2__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
if (true) {
  HistoryRouter.displayName = "unstable_HistoryRouter";
}
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined";
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
/**
 * The public API for rendering a history-aware `<a>`.
 */
const Link = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function LinkWithRef(_ref7, ref) {
  let {
      onClick,
      relative,
      reloadDocument,
      replace,
      state,
      target,
      to,
      preventScrollReset,
      viewTransition
    } = _ref7,
    rest = _objectWithoutPropertiesLoose(_ref7, _excluded);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  // Rendered into <a href> for absolute URLs
  let absoluteHref;
  let isExternal = false;
  if (typeof to === "string" && ABSOLUTE_URL_REGEX.test(to)) {
    // Render the absolute href server- and client-side
    absoluteHref = to;
    // Only check for external origins client-side
    if (isBrowser) {
      try {
        let currentUrl = new URL(window.location.href);
        let targetUrl = to.startsWith("//") ? new URL(currentUrl.protocol + to) : new URL(to);
        let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(targetUrl.pathname, basename);
        if (targetUrl.origin === currentUrl.origin && path != null) {
          // Strip the protocol/origin/basename for same-origin absolute URLs
          to = path + targetUrl.search + targetUrl.hash;
        } else {
          isExternal = true;
        }
      } catch (e) {
        // We can't do external URL detection without a valid URL
         true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "<Link to=\"" + to + "\"> contains an invalid URL which will probably break " + "when clicked - please update to a valid URL path.") : 0;
      }
    }
  }
  // Rendered into <a href> for relative URLs
  let href = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useHref)(to, {
    relative
  });
  let internalOnClick = useLinkClickHandler(to, {
    replace,
    state,
    target,
    preventScrollReset,
    relative,
    viewTransition
  });
  function handleClick(event) {
    if (onClick) onClick(event);
    if (!event.defaultPrevented) {
      internalOnClick(event);
    }
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/anchor-has-content
    react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", _extends({}, rest, {
      href: absoluteHref || href,
      onClick: isExternal || reloadDocument ? onClick : handleClick,
      ref: ref,
      target: target
    }))
  );
});
if (true) {
  Link.displayName = "Link";
}
/**
 * A `<Link>` wrapper that knows if it's "active" or not.
 */
const NavLink = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function NavLinkWithRef(_ref8, ref) {
  let {
      "aria-current": ariaCurrentProp = "page",
      caseSensitive = false,
      className: classNameProp = "",
      end = false,
      style: styleProp,
      to,
      viewTransition,
      children
    } = _ref8,
    rest = _objectWithoutPropertiesLoose(_ref8, _excluded2);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative: rest.relative
  });
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let routerState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext);
  let {
    navigator,
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let isTransitioning = routerState != null &&
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  useViewTransitionState(path) && viewTransition === true;
  let toPathname = navigator.encodeLocation ? navigator.encodeLocation(path).pathname : path.pathname;
  let locationPathname = location.pathname;
  let nextLocationPathname = routerState && routerState.navigation && routerState.navigation.location ? routerState.navigation.location.pathname : null;
  if (!caseSensitive) {
    locationPathname = locationPathname.toLowerCase();
    nextLocationPathname = nextLocationPathname ? nextLocationPathname.toLowerCase() : null;
    toPathname = toPathname.toLowerCase();
  }
  if (nextLocationPathname && basename) {
    nextLocationPathname = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(nextLocationPathname, basename) || nextLocationPathname;
  }
  // If the `to` has a trailing slash, look at that exact spot.  Otherwise,
  // we're looking for a slash _after_ what's in `to`.  For example:
  //
  // <NavLink to="/users"> and <NavLink to="/users/">
  // both want to look for a / at index 6 to match URL `/users/matt`
  const endSlashPosition = toPathname !== "/" && toPathname.endsWith("/") ? toPathname.length - 1 : toPathname.length;
  let isActive = locationPathname === toPathname || !end && locationPathname.startsWith(toPathname) && locationPathname.charAt(endSlashPosition) === "/";
  let isPending = nextLocationPathname != null && (nextLocationPathname === toPathname || !end && nextLocationPathname.startsWith(toPathname) && nextLocationPathname.charAt(toPathname.length) === "/");
  let renderProps = {
    isActive,
    isPending,
    isTransitioning
  };
  let ariaCurrent = isActive ? ariaCurrentProp : undefined;
  let className;
  if (typeof classNameProp === "function") {
    className = classNameProp(renderProps);
  } else {
    // If the className prop is not a function, we use a default `active`
    // class for <NavLink />s that are active. In v5 `active` was the default
    // value for `activeClassName`, but we are removing that API and can still
    // use the old default behavior for a cleaner upgrade path and keep the
    // simple styling rules working as they currently do.
    className = [classNameProp, isActive ? "active" : null, isPending ? "pending" : null, isTransitioning ? "transitioning" : null].filter(Boolean).join(" ");
  }
  let style = typeof styleProp === "function" ? styleProp(renderProps) : styleProp;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Link, _extends({}, rest, {
    "aria-current": ariaCurrent,
    className: className,
    ref: ref,
    style: style,
    to: to,
    viewTransition: viewTransition
  }), typeof children === "function" ? children(renderProps) : children);
});
if (true) {
  NavLink.displayName = "NavLink";
}
/**
 * A `@remix-run/router`-aware `<form>`. It behaves like a normal form except
 * that the interaction with the server is with `fetch` instead of new document
 * requests, allowing components to add nicer UX to the page as the form is
 * submitted and returns with data.
 */
const Form = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((_ref9, forwardedRef) => {
  let {
      fetcherKey,
      navigate,
      reloadDocument,
      replace,
      state,
      method = defaultMethod,
      action,
      onSubmit,
      relative,
      preventScrollReset,
      viewTransition
    } = _ref9,
    props = _objectWithoutPropertiesLoose(_ref9, _excluded3);
  let submit = useSubmit();
  let formAction = useFormAction(action, {
    relative
  });
  let formMethod = method.toLowerCase() === "get" ? "get" : "post";
  let submitHandler = event => {
    onSubmit && onSubmit(event);
    if (event.defaultPrevented) return;
    event.preventDefault();
    let submitter = event.nativeEvent.submitter;
    let submitMethod = (submitter == null ? void 0 : submitter.getAttribute("formmethod")) || method;
    submit(submitter || event.currentTarget, {
      fetcherKey,
      method: submitMethod,
      navigate,
      replace,
      state,
      relative,
      preventScrollReset,
      viewTransition
    });
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", _extends({
    ref: forwardedRef,
    method: formMethod,
    action: formAction,
    onSubmit: reloadDocument ? onSubmit : submitHandler
  }, props));
});
if (true) {
  Form.displayName = "Form";
}
/**
 * This component will emulate the browser's scroll restoration on location
 * changes.
 */
function ScrollRestoration(_ref10) {
  let {
    getKey,
    storageKey
  } = _ref10;
  useScrollRestoration({
    getKey,
    storageKey
  });
  return null;
}
if (true) {
  ScrollRestoration.displayName = "ScrollRestoration";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Hooks
////////////////////////////////////////////////////////////////////////////////
var DataRouterHook;
(function (DataRouterHook) {
  DataRouterHook["UseScrollRestoration"] = "useScrollRestoration";
  DataRouterHook["UseSubmit"] = "useSubmit";
  DataRouterHook["UseSubmitFetcher"] = "useSubmitFetcher";
  DataRouterHook["UseFetcher"] = "useFetcher";
  DataRouterHook["useViewTransitionState"] = "useViewTransitionState";
})(DataRouterHook || (DataRouterHook = {}));
var DataRouterStateHook;
(function (DataRouterStateHook) {
  DataRouterStateHook["UseFetcher"] = "useFetcher";
  DataRouterStateHook["UseFetchers"] = "useFetchers";
  DataRouterStateHook["UseScrollRestoration"] = "useScrollRestoration";
})(DataRouterStateHook || (DataRouterStateHook = {}));
// Internal hooks
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/v6/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterContext);
  !ctx ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_DataRouterStateContext);
  !state ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
// External hooks
/**
 * Handles the click behavior for router `<Link>` components. This is useful if
 * you need to create custom `<Link>` components with the same click behavior we
 * use in our exported `<Link>`.
 */
function useLinkClickHandler(to, _temp) {
  let {
    target,
    replace: replaceProp,
    state,
    preventScrollReset,
    relative,
    viewTransition
  } = _temp === void 0 ? {} : _temp;
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(event => {
    if (shouldProcessLinkClick(event, target)) {
      event.preventDefault();
      // If the URL hasn't changed, a regular <a> will do a replace instead of
      // a push, so do the same here unless the replace prop is explicitly set
      let replace = replaceProp !== undefined ? replaceProp : (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(location) === (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(path);
      navigate(to, {
        replace,
        state,
        preventScrollReset,
        relative,
        viewTransition
      });
    }
  }, [location, navigate, path, replaceProp, state, target, to, preventScrollReset, relative, viewTransition]);
}
/**
 * A convenient wrapper for reading and writing search parameters via the
 * URLSearchParams interface.
 */
function useSearchParams(defaultInit) {
   true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(typeof URLSearchParams !== "undefined", "You cannot use the `useSearchParams` hook in a browser that does not " + "support the URLSearchParams API. If you need to support Internet " + "Explorer 11, we recommend you load a polyfill such as " + "https://github.com/ungap/url-search-params.") : 0;
  let defaultSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(createSearchParams(defaultInit));
  let hasSetSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let searchParams = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() =>
  // Only merge in the defaults if we haven't yet called setSearchParams.
  // Once we call that we want those to take precedence, otherwise you can't
  // remove a param with setSearchParams({}) if it has an initial value
  getSearchParamsForLocation(location.search, hasSetSearchParamsRef.current ? null : defaultSearchParamsRef.current), [location.search]);
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
  let setSearchParams = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((nextInit, navigateOptions) => {
    const newSearchParams = createSearchParams(typeof nextInit === "function" ? nextInit(searchParams) : nextInit);
    hasSetSearchParamsRef.current = true;
    navigate("?" + newSearchParams, navigateOptions);
  }, [navigate, searchParams]);
  return [searchParams, setSearchParams];
}
function validateClientSideSubmission() {
  if (typeof document === "undefined") {
    throw new Error("You are calling submit during the server render. " + "Try calling submit within a `useEffect` or callback instead.");
  }
}
let fetcherId = 0;
let getUniqueFetcherId = () => "__" + String(++fetcherId) + "__";
/**
 * Returns a function that may be used to programmatically submit a form (or
 * some arbitrary data) to the server.
 */
function useSubmit() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseSubmit);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let currentRouteId = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_useRouteId)();
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (target, options) {
    if (options === void 0) {
      options = {};
    }
    validateClientSideSubmission();
    let {
      action,
      method,
      encType,
      formData,
      body
    } = getFormSubmissionInfo(target, basename);
    if (options.navigate === false) {
      let key = options.fetcherKey || getUniqueFetcherId();
      router.fetch(key, currentRouteId, options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        flushSync: options.flushSync
      });
    } else {
      router.navigate(options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        replace: options.replace,
        state: options.state,
        fromRouteId: currentRouteId,
        flushSync: options.flushSync,
        viewTransition: options.viewTransition
      });
    }
  }, [router, basename, currentRouteId]);
}
// v7: Eventually we should deprecate this entirely in favor of using the
// router method directly?
function useFormAction(action, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let routeContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext);
  !routeContext ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFormAction must be used inside a RouteContext") : 0 : void 0;
  let [match] = routeContext.matches.slice(-1);
  // Shallow clone path so we can modify it below, otherwise we modify the
  // object referenced by useMemo inside useResolvedPath
  let path = _extends({}, (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(action ? action : ".", {
    relative
  }));
  // If no action was specified, browsers will persist current search params
  // when determining the path, so match that behavior
  // https://github.com/remix-run/remix/issues/927
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  if (action == null) {
    // Safe to write to this directly here since if action was undefined, we
    // would have called useResolvedPath(".") which will never include a search
    path.search = location.search;
    // When grabbing search params from the URL, remove any included ?index param
    // since it might not apply to our contextual route.  We add it back based
    // on match.route.index below
    let params = new URLSearchParams(path.search);
    let indexValues = params.getAll("index");
    let hasNakedIndexParam = indexValues.some(v => v === "");
    if (hasNakedIndexParam) {
      params.delete("index");
      indexValues.filter(v => v).forEach(v => params.append("index", v));
      let qs = params.toString();
      path.search = qs ? "?" + qs : "";
    }
  }
  if ((!action || action === ".") && match.route.index) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the form action.  If this is a root navigation, then just use
  // the raw basename which allows the basename to have full control over the
  // presence of a trailing slash on root actions
  if (basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : (0,react_router__WEBPACK_IMPORTED_MODULE_3__.joinPaths)([basename, path.pathname]);
  }
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.createPath)(path);
}
// TODO: (v7) Change the useFetcher generic default from `any` to `unknown`
/**
 * Interacts with route loaders and actions without causing a navigation. Great
 * for any interaction that stays on the same page.
 */
function useFetcher(_temp3) {
  var _route$matches;
  let {
    key
  } = _temp3 === void 0 ? {} : _temp3;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseFetcher);
  let state = useDataRouterState(DataRouterStateHook.UseFetcher);
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useContext(FetchersContext);
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_RouteContext);
  let routeId = (_route$matches = route.matches[route.matches.length - 1]) == null ? void 0 : _route$matches.route.id;
  !fetcherData ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher must be used inside a FetchersContext") : 0 : void 0;
  !route ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher must be used inside a RouteContext") : 0 : void 0;
  !(routeId != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "useFetcher can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  // Fetcher key handling
  // OK to call conditionally to feature detect `useId`
  // eslint-disable-next-line react-hooks/rules-of-hooks
  let defaultKey = useIdImpl ? useIdImpl() : "";
  let [fetcherKey, setFetcherKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState(key || defaultKey);
  if (key && key !== fetcherKey) {
    setFetcherKey(key);
  } else if (!fetcherKey) {
    // We will only fall through here when `useId` is not available
    setFetcherKey(getUniqueFetcherId());
  }
  // Registration/cleanup
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    router.getFetcher(fetcherKey);
    return () => {
      // Tell the router we've unmounted - if v7_fetcherPersist is enabled this
      // will not delete immediately but instead queue up a delete after the
      // fetcher returns to an `idle` state
      router.deleteFetcher(fetcherKey);
    };
  }, [router, fetcherKey]);
  // Fetcher additions
  let load = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((href, opts) => {
    !routeId ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "No routeId available for fetcher.load()") : 0 : void 0;
    router.fetch(fetcherKey, routeId, href, opts);
  }, [fetcherKey, routeId, router]);
  let submitImpl = useSubmit();
  let submit = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((target, opts) => {
    submitImpl(target, _extends({}, opts, {
      navigate: false,
      fetcherKey
    }));
  }, [fetcherKey, submitImpl]);
  let FetcherForm = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let FetcherForm = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Form, _extends({}, props, {
        navigate: false,
        fetcherKey: fetcherKey,
        ref: ref
      }));
    });
    if (true) {
      FetcherForm.displayName = "fetcher.Form";
    }
    return FetcherForm;
  }, [fetcherKey]);
  // Exposed FetcherWithComponents
  let fetcher = state.fetchers.get(fetcherKey) || react_router__WEBPACK_IMPORTED_MODULE_3__.IDLE_FETCHER;
  let data = fetcherData.get(fetcherKey);
  let fetcherWithComponents = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => _extends({
    Form: FetcherForm,
    submit,
    load
  }, fetcher, {
    data
  }), [FetcherForm, submit, load, fetcher, data]);
  return fetcherWithComponents;
}
/**
 * Provides all fetchers currently on the page. Useful for layouts and parent
 * routes that need to provide pending/optimistic UI regarding the fetch.
 */
function useFetchers() {
  let state = useDataRouterState(DataRouterStateHook.UseFetchers);
  return Array.from(state.fetchers.entries()).map(_ref11 => {
    let [key, fetcher] = _ref11;
    return _extends({}, fetcher, {
      key
    });
  });
}
const SCROLL_RESTORATION_STORAGE_KEY = "react-router-scroll-positions";
let savedScrollPositions = {};
/**
 * When rendered inside a RouterProvider, will restore scroll positions on navigations
 */
function useScrollRestoration(_temp4) {
  let {
    getKey,
    storageKey
  } = _temp4 === void 0 ? {} : _temp4;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseScrollRestoration);
  let {
    restoreScrollPosition,
    preventScrollReset
  } = useDataRouterState(DataRouterStateHook.UseScrollRestoration);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_NavigationContext);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useLocation)();
  let matches = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useMatches)();
  let navigation = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useNavigation)();
  // Trigger manual scroll restoration while we're active
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    window.history.scrollRestoration = "manual";
    return () => {
      window.history.scrollRestoration = "auto";
    };
  }, []);
  // Save positions on pagehide
  usePageHide(react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (navigation.state === "idle") {
      let key = (getKey ? getKey(location, matches) : null) || location.key;
      savedScrollPositions[key] = window.scrollY;
    }
    try {
      sessionStorage.setItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY, JSON.stringify(savedScrollPositions));
    } catch (error) {
       true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_warning)(false, "Failed to save scroll positions in sessionStorage, <ScrollRestoration /> will not work properly (" + error + ").") : 0;
    }
    window.history.scrollRestoration = "auto";
  }, [storageKey, getKey, navigation.state, location, matches]));
  // Read in any saved scroll locations
  if (typeof document !== "undefined") {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      try {
        let sessionPositions = sessionStorage.getItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY);
        if (sessionPositions) {
          savedScrollPositions = JSON.parse(sessionPositions);
        }
      } catch (e) {
        // no-op, use default empty object
      }
    }, [storageKey]);
    // Enable scroll restoration in the router
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      let getKeyWithoutBasename = getKey && basename !== "/" ? (location, matches) => getKey( // Strip the basename to match useLocation()
      _extends({}, location, {
        pathname: (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(location.pathname, basename) || location.pathname
      }), matches) : getKey;
      let disableScrollRestoration = router == null ? void 0 : router.enableScrollRestoration(savedScrollPositions, () => window.scrollY, getKeyWithoutBasename);
      return () => disableScrollRestoration && disableScrollRestoration();
    }, [router, basename, getKey]);
    // Restore scrolling when state.restoreScrollPosition changes
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      // Explicit false means don't do anything (used for submissions)
      if (restoreScrollPosition === false) {
        return;
      }
      // been here before, scroll to it
      if (typeof restoreScrollPosition === "number") {
        window.scrollTo(0, restoreScrollPosition);
        return;
      }
      // try to scroll to the hash
      if (location.hash) {
        let el = document.getElementById(decodeURIComponent(location.hash.slice(1)));
        if (el) {
          el.scrollIntoView();
          return;
        }
      }
      // Don't reset if this navigation opted out
      if (preventScrollReset === true) {
        return;
      }
      // otherwise go to the top on new locations
      window.scrollTo(0, 0);
    }, [location, restoreScrollPosition, preventScrollReset]);
  }
}
/**
 * Setup a callback to be fired on the window's `beforeunload` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function useBeforeUnload(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("beforeunload", callback, opts);
    return () => {
      window.removeEventListener("beforeunload", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Setup a callback to be fired on the window's `pagehide` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.  This event is better supported than beforeunload across browsers.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function usePageHide(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("pagehide", callback, opts);
    return () => {
      window.removeEventListener("pagehide", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Wrapper around useBlocker to show a window.confirm prompt to users instead
 * of building a custom UI with useBlocker.
 *
 * Warning: This has *a lot of rough edges* and behaves very differently (and
 * very incorrectly in some cases) across browsers if user click addition
 * back/forward navigations while the confirm is open.  Use at your own risk.
 */
function usePrompt(_ref12) {
  let {
    when,
    message
  } = _ref12;
  let blocker = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useBlocker)(when);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked") {
      let proceed = window.confirm(message);
      if (proceed) {
        // This timeout is needed to avoid a weird "race" on POP navigations
        // between the `window.history` revert navigation and the result of
        // `window.confirm`
        setTimeout(blocker.proceed, 0);
      } else {
        blocker.reset();
      }
    }
  }, [blocker, message]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked" && !when) {
      blocker.reset();
    }
  }, [blocker, when]);
}
/**
 * Return a boolean indicating if there is an active view transition to the
 * given href.  You can use this value to render CSS classes or viewTransitionName
 * styles onto your elements
 *
 * @param href The destination href
 * @param [opts.relative] Relative routing type ("route" | "path")
 */
function useViewTransitionState(to, opts) {
  if (opts === void 0) {
    opts = {};
  }
  let vtContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ViewTransitionContext);
  !(vtContext != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_invariant)(false, "`useViewTransitionState` must be used within `react-router-dom`'s `RouterProvider`.  " + "Did you accidentally import `RouterProvider` from `react-router`?") : 0 : void 0;
  let {
    basename
  } = useDataRouterContext(DataRouterHook.useViewTransitionState);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.useResolvedPath)(to, {
    relative: opts.relative
  });
  if (!vtContext.isTransitioning) {
    return false;
  }
  let currentPath = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(vtContext.currentLocation.pathname, basename) || vtContext.currentLocation.pathname;
  let nextPath = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.stripBasename)(vtContext.nextLocation.pathname, basename) || vtContext.nextLocation.pathname;
  // Transition is active if we're going to or coming from the indicated
  // destination.  This ensures that other PUSH navigations that reverse
  // an indicated transition apply.  I.e., on the list view you have:
  //
  //   <NavLink to="/details/1" viewTransition>
  //
  // If you click the breadcrumb back to the list view:
  //
  //   <NavLink to="/list" viewTransition>
  //
  // We should apply the transition because it's indicated as active going
  // from /list -> /details/1 and therefore should be active on the reverse
  // (even though this isn't strictly a POP reverse)
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath)(path.pathname, nextPath) != null || (0,react_router__WEBPACK_IMPORTED_MODULE_3__.matchPath)(path.pathname, currentPath) != null;
}
//#endregion


//# sourceMappingURL=index.js.map


/***/ },

/***/ "./node_modules/react-router/dist/index.js"
/*!*************************************************!*\
  !*** ./node_modules/react-router/dist/index.js ***!
  \*************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError),
/* harmony export */   Await: () => (/* binding */ Await),
/* harmony export */   MemoryRouter: () => (/* binding */ MemoryRouter),
/* harmony export */   Navigate: () => (/* binding */ Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action),
/* harmony export */   Outlet: () => (/* binding */ Outlet),
/* harmony export */   Route: () => (/* binding */ Route),
/* harmony export */   Router: () => (/* binding */ Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* binding */ Routes),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* binding */ DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* binding */ DataRouterStateContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* binding */ LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* binding */ NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* binding */ RouteContext),
/* harmony export */   UNSAFE_logV6DeprecationWarnings: () => (/* binding */ logV6DeprecationWarnings),
/* harmony export */   UNSAFE_mapRouteProperties: () => (/* binding */ mapRouteProperties),
/* harmony export */   UNSAFE_useRouteId: () => (/* binding */ useRouteId),
/* harmony export */   UNSAFE_useRoutesImpl: () => (/* binding */ useRoutesImpl),
/* harmony export */   createMemoryRouter: () => (/* binding */ createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   defer: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirectDocument),
/* harmony export */   renderMatches: () => (/* binding */ renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolvePath),
/* harmony export */   useActionData: () => (/* binding */ useActionData),
/* harmony export */   useAsyncError: () => (/* binding */ useAsyncError),
/* harmony export */   useAsyncValue: () => (/* binding */ useAsyncValue),
/* harmony export */   useBlocker: () => (/* binding */ useBlocker),
/* harmony export */   useHref: () => (/* binding */ useHref),
/* harmony export */   useInRouterContext: () => (/* binding */ useInRouterContext),
/* harmony export */   useLoaderData: () => (/* binding */ useLoaderData),
/* harmony export */   useLocation: () => (/* binding */ useLocation),
/* harmony export */   useMatch: () => (/* binding */ useMatch),
/* harmony export */   useMatches: () => (/* binding */ useMatches),
/* harmony export */   useNavigate: () => (/* binding */ useNavigate),
/* harmony export */   useNavigation: () => (/* binding */ useNavigation),
/* harmony export */   useNavigationType: () => (/* binding */ useNavigationType),
/* harmony export */   useOutlet: () => (/* binding */ useOutlet),
/* harmony export */   useOutletContext: () => (/* binding */ useOutletContext),
/* harmony export */   useParams: () => (/* binding */ useParams),
/* harmony export */   useResolvedPath: () => (/* binding */ useResolvedPath),
/* harmony export */   useRevalidator: () => (/* binding */ useRevalidator),
/* harmony export */   useRouteError: () => (/* binding */ useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* binding */ useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* binding */ useRoutes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _remix_run_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router v6.30.3
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */




function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

// Create react-specific types from the agnostic types in @remix-run/router to
// export from react-router
const DataRouterContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterContext.displayName = "DataRouter";
}
const DataRouterStateContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterStateContext.displayName = "DataRouterState";
}
const AwaitContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  AwaitContext.displayName = "Await";
}

/**
 * A Navigator is a "location changer"; it's how you get to different locations.
 *
 * Every history instance conforms to the Navigator interface, but the
 * distinction is useful primarily when it comes to the low-level `<Router>` API
 * where both the location and a navigator must be provided separately in order
 * to avoid "tearing" that may occur in a suspense-enabled app if the action
 * and/or location were to be read directly from the history instance.
 */

const NavigationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  NavigationContext.displayName = "Navigation";
}
const LocationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  LocationContext.displayName = "Location";
}
const RouteContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  outlet: null,
  matches: [],
  isDataRoute: false
});
if (true) {
  RouteContext.displayName = "Route";
}
const RouteErrorContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  RouteErrorContext.displayName = "RouteError";
}

/**
 * Returns the full href for the given "to" value. This is useful for building
 * custom links that are also accessible and preserve right-click behavior.
 *
 * @see https://reactrouter.com/v6/hooks/use-href
 */
function useHref(to, _temp) {
  let {
    relative
  } = _temp === void 0 ? {} : _temp;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useHref() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    basename,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    hash,
    pathname,
    search
  } = useResolvedPath(to, {
    relative
  });
  let joinedPathname = pathname;

  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the href.  If this is a root navigation, then just use the raw
  // basename which allows the basename to have full control over the presence
  // of a trailing slash on root links
  if (basename !== "/") {
    joinedPathname = pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, pathname]);
  }
  return navigator.createHref({
    pathname: joinedPathname,
    search,
    hash
  });
}

/**
 * Returns true if this component is a descendant of a `<Router>`.
 *
 * @see https://reactrouter.com/v6/hooks/use-in-router-context
 */
function useInRouterContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext) != null;
}

/**
 * Returns the current location object, which represents the current URL in web
 * browsers.
 *
 * Note: If you're using this it may mean you're doing some of your own
 * "routing" in your app, and we'd like to know what your use case is. We may
 * be able to provide something higher-level to better suit your needs.
 *
 * @see https://reactrouter.com/v6/hooks/use-location
 */
function useLocation() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useLocation() may be used only in the context of a <Router> component.") : 0 : void 0;
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).location;
}

/**
 * Returns the current navigation action which describes how the router came to
 * the current location, either by a pop, push, or replace on the history stack.
 *
 * @see https://reactrouter.com/v6/hooks/use-navigation-type
 */
function useNavigationType() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).navigationType;
}

/**
 * Returns a PathMatch object if the given pattern matches the current URL.
 * This is useful for components that need to know "active" state, e.g.
 * `<NavLink>`.
 *
 * @see https://reactrouter.com/v6/hooks/use-match
 */
function useMatch(pattern) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useMatch() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    pathname
  } = useLocation();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath)(pattern, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_decodePath)(pathname)), [pathname, pattern]);
}

/**
 * The interface for the navigate() function returned from useNavigate().
 */

const navigateEffectWarning = "You should call navigate() in a React.useEffect(), not when " + "your component is first rendered.";

// Mute warnings for calls to useNavigate in SSR environments
function useIsomorphicLayoutEffect(cb) {
  let isStatic = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext).static;
  if (!isStatic) {
    // We should be able to get rid of this once react 18.3 is released
    // See: https://github.com/facebook/react/pull/26395
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(cb);
  }
}

/**
 * Returns an imperative method for changing the location. Used by `<Link>`s, but
 * may also be used by other elements to change the location.
 *
 * @see https://reactrouter.com/v6/hooks/use-navigate
 */
function useNavigate() {
  let {
    isDataRoute
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  return isDataRoute ? useNavigateStable() : useNavigateUnstable();
}
function useNavigateUnstable() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useNavigate() may be used only in the context of a <Router> component.") : 0 : void 0;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  let {
    basename,
    future,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our history listener yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      navigator.go(to);
      return;
    }
    let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, options.relative === "path");

    // If we're operating within a basename, prepend it to the pathname prior
    // to handing off to history (but only if we're not in a data router,
    // otherwise it'll prepend the basename inside of the router).
    // If this is a root navigation, then we navigate to the raw basename
    // which allows the basename to have full control over the presence of a
    // trailing slash on root links
    if (dataRouterContext == null && basename !== "/") {
      path.pathname = path.pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, path.pathname]);
    }
    (!!options.replace ? navigator.replace : navigator.push)(path, options.state, options);
  }, [basename, navigator, routePathnamesJson, locationPathname, dataRouterContext]);
  return navigate;
}
const OutletContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);

/**
 * Returns the context (if provided) for the child route at this level of the route
 * hierarchy.
 * @see https://reactrouter.com/v6/hooks/use-outlet-context
 */
function useOutletContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(OutletContext);
}

/**
 * Returns the element for the child route at this level of the route
 * hierarchy. Used internally by `<Outlet>` to render child routes.
 *
 * @see https://reactrouter.com/v6/hooks/use-outlet
 */
function useOutlet(context) {
  let outlet = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext).outlet;
  if (outlet) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(OutletContext.Provider, {
      value: context
    }, outlet);
  }
  return outlet;
}

/**
 * Returns an object of key/value pairs of the dynamic params from the current
 * URL that were matched by the route path.
 *
 * @see https://reactrouter.com/v6/hooks/use-params
 */
function useParams() {
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = matches[matches.length - 1];
  return routeMatch ? routeMatch.params : {};
}

/**
 * Resolves the pathname of the given `to` value against the current location.
 *
 * @see https://reactrouter.com/v6/hooks/use-resolved-path
 */
function useResolvedPath(to, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    future
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, relative === "path"), [to, routePathnamesJson, locationPathname, relative]);
}

/**
 * Returns the element of the route that matched the current location, prepared
 * with the correct context to render the remainder of the route tree. Route
 * elements in the tree must render an `<Outlet>` to render their child route's
 * element.
 *
 * @see https://reactrouter.com/v6/hooks/use-routes
 */
function useRoutes(routes, locationArg) {
  return useRoutesImpl(routes, locationArg);
}

// Internal implementation with accept optional param for RouterProvider usage
function useRoutesImpl(routes, locationArg, dataRouterState, future) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useRoutes() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches: parentMatches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = parentMatches[parentMatches.length - 1];
  let parentParams = routeMatch ? routeMatch.params : {};
  let parentPathname = routeMatch ? routeMatch.pathname : "/";
  let parentPathnameBase = routeMatch ? routeMatch.pathnameBase : "/";
  let parentRoute = routeMatch && routeMatch.route;
  if (true) {
    // You won't get a warning about 2 different <Routes> under a <Route>
    // without a trailing *, but this is a best-effort warning anyway since we
    // cannot even give the warning unless they land at the parent route.
    //
    // Example:
    //
    // <Routes>
    //   {/* This route path MUST end with /* because otherwise
    //       it will never match /blog/post/123 */}
    //   <Route path="blog" element={<Blog />} />
    //   <Route path="blog/feed" element={<BlogFeed />} />
    // </Routes>
    //
    // function Blog() {
    //   return (
    //     <Routes>
    //       <Route path="post/:id" element={<Post />} />
    //     </Routes>
    //   );
    // }
    let parentPath = parentRoute && parentRoute.path || "";
    warningOnce(parentPathname, !parentRoute || parentPath.endsWith("*"), "You rendered descendant <Routes> (or called `useRoutes()`) at " + ("\"" + parentPathname + "\" (under <Route path=\"" + parentPath + "\">) but the ") + "parent route path has no trailing \"*\". This means if you navigate " + "deeper, the parent won't match anymore and therefore the child " + "routes will never render.\n\n" + ("Please change the parent <Route path=\"" + parentPath + "\"> to <Route ") + ("path=\"" + (parentPath === "/" ? "*" : parentPath + "/*") + "\">."));
  }
  let locationFromContext = useLocation();
  let location;
  if (locationArg) {
    var _parsedLocationArg$pa;
    let parsedLocationArg = typeof locationArg === "string" ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationArg) : locationArg;
    !(parentPathnameBase === "/" || ((_parsedLocationArg$pa = parsedLocationArg.pathname) == null ? void 0 : _parsedLocationArg$pa.startsWith(parentPathnameBase))) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "When overriding the location using `<Routes location>` or `useRoutes(routes, location)`, " + "the location pathname must begin with the portion of the URL pathname that was " + ("matched by all parent routes. The current pathname base is \"" + parentPathnameBase + "\" ") + ("but pathname \"" + parsedLocationArg.pathname + "\" was given in the `location` prop.")) : 0 : void 0;
    location = parsedLocationArg;
  } else {
    location = locationFromContext;
  }
  let pathname = location.pathname || "/";
  let remainingPathname = pathname;
  if (parentPathnameBase !== "/") {
    // Determine the remaining pathname by removing the # of URL segments the
    // parentPathnameBase has, instead of removing based on character count.
    // This is because we can't guarantee that incoming/outgoing encodings/
    // decodings will match exactly.
    // We decode paths before matching on a per-segment basis with
    // decodeURIComponent(), but we re-encode pathnames via `new URL()` so they
    // match what `window.location.pathname` would reflect.  Those don't 100%
    // align when it comes to encoded URI characters such as % and &.
    //
    // So we may end up with:
    //   pathname:           "/descendant/a%25b/match"
    //   parentPathnameBase: "/descendant/a%b"
    //
    // And the direct substring removal approach won't work :/
    let parentSegments = parentPathnameBase.replace(/^\//, "").split("/");
    let segments = pathname.replace(/^\//, "").split("/");
    remainingPathname = "/" + segments.slice(parentSegments.length).join("/");
  }
  let matches = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes)(routes, {
    pathname: remainingPathname
  });
  if (true) {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(parentRoute || matches != null, "No routes matched location \"" + location.pathname + location.search + location.hash + "\" ") : 0;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(matches == null || matches[matches.length - 1].route.element !== undefined || matches[matches.length - 1].route.Component !== undefined || matches[matches.length - 1].route.lazy !== undefined, "Matched leaf route at location \"" + location.pathname + location.search + location.hash + "\" " + "does not have an element or Component. This means it will render an <Outlet /> with a " + "null value by default resulting in an \"empty\" page.") : 0;
  }
  let renderedMatches = _renderMatches(matches && matches.map(match => Object.assign({}, match, {
    params: Object.assign({}, parentParams, match.params),
    pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathname).pathname : match.pathname]),
    pathnameBase: match.pathnameBase === "/" ? parentPathnameBase : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathnameBase).pathname : match.pathnameBase])
  })), parentMatches, dataRouterState, future);

  // When a user passes in a `locationArg`, the associated routes need to
  // be wrapped in a new `LocationContext.Provider` in order for `useLocation`
  // to use the scoped location instead of the global location.
  if (locationArg && renderedMatches) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
      value: {
        location: _extends({
          pathname: "/",
          search: "",
          hash: "",
          state: null,
          key: "default"
        }, location),
        navigationType: _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop
      }
    }, renderedMatches);
  }
  return renderedMatches;
}
function DefaultErrorComponent() {
  let error = useRouteError();
  let message = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse)(error) ? error.status + " " + error.statusText : error instanceof Error ? error.message : JSON.stringify(error);
  let stack = error instanceof Error ? error.stack : null;
  let lightgrey = "rgba(200,200,200, 0.5)";
  let preStyles = {
    padding: "0.5rem",
    backgroundColor: lightgrey
  };
  let codeStyles = {
    padding: "2px 4px",
    backgroundColor: lightgrey
  };
  let devInfo = null;
  if (true) {
    console.error("Error handled by React Router default ErrorBoundary:", error);
    devInfo = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "\uD83D\uDCBF Hey developer \uD83D\uDC4B"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "You can provide a way better UX than this when your app throws errors by providing your own ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "ErrorBoundary"), " or", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "errorElement"), " prop on your route."));
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, "Unexpected Application Error!"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", {
    style: {
      fontStyle: "italic"
    }
  }, message), stack ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", {
    style: preStyles
  }, stack) : null, devInfo);
}
const defaultErrorElement = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DefaultErrorComponent, null);
class RenderErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      location: props.location,
      revalidation: props.revalidation,
      error: props.error
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error: error
    };
  }
  static getDerivedStateFromProps(props, state) {
    // When we get into an error state, the user will likely click "back" to the
    // previous page that didn't have an error. Because this wraps the entire
    // application, that will have no effect--the error page continues to display.
    // This gives us a mechanism to recover from the error when the location changes.
    //
    // Whether we're in an error state or not, we update the location in state
    // so that when we are in an error state, it gets reset when a new location
    // comes in and the user recovers from the error.
    if (state.location !== props.location || state.revalidation !== "idle" && props.revalidation === "idle") {
      return {
        error: props.error,
        location: props.location,
        revalidation: props.revalidation
      };
    }

    // If we're not changing locations, preserve the location but still surface
    // any new errors that may come through. We retain the existing error, we do
    // this because the error provided from the app state may be cleared without
    // the location changing.
    return {
      error: props.error !== undefined ? props.error : state.error,
      location: state.location,
      revalidation: props.revalidation || state.revalidation
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("React Router caught the following error during render", error, errorInfo);
  }
  render() {
    return this.state.error !== undefined ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
      value: this.props.routeContext
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteErrorContext.Provider, {
      value: this.state.error,
      children: this.props.component
    })) : this.props.children;
  }
}
function RenderedRoute(_ref) {
  let {
    routeContext,
    match,
    children
  } = _ref;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);

  // Track how deep we got in our render pass to emulate SSR componentDidCatch
  // in a DataStaticRouter
  if (dataRouterContext && dataRouterContext.static && dataRouterContext.staticContext && (match.route.errorElement || match.route.ErrorBoundary)) {
    dataRouterContext.staticContext._deepestRenderedBoundaryId = match.route.id;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
    value: routeContext
  }, children);
}
function _renderMatches(matches, parentMatches, dataRouterState, future) {
  var _dataRouterState;
  if (parentMatches === void 0) {
    parentMatches = [];
  }
  if (dataRouterState === void 0) {
    dataRouterState = null;
  }
  if (future === void 0) {
    future = null;
  }
  if (matches == null) {
    var _future;
    if (!dataRouterState) {
      return null;
    }
    if (dataRouterState.errors) {
      // Don't bail if we have data router errors so we can render them in the
      // boundary.  Use the pre-matched (or shimmed) matches
      matches = dataRouterState.matches;
    } else if ((_future = future) != null && _future.v7_partialHydration && parentMatches.length === 0 && !dataRouterState.initialized && dataRouterState.matches.length > 0) {
      // Don't bail if we're initializing with partial hydration and we have
      // router matches.  That means we're actively running `patchRoutesOnNavigation`
      // so we should render down the partial matches to the appropriate
      // `HydrateFallback`.  We only do this if `parentMatches` is empty so it
      // only impacts the root matches for `RouterProvider` and no descendant
      // `<Routes>`
      matches = dataRouterState.matches;
    } else {
      return null;
    }
  }
  let renderedMatches = matches;

  // If we have data errors, trim matches to the highest error boundary
  let errors = (_dataRouterState = dataRouterState) == null ? void 0 : _dataRouterState.errors;
  if (errors != null) {
    let errorIndex = renderedMatches.findIndex(m => m.route.id && (errors == null ? void 0 : errors[m.route.id]) !== undefined);
    !(errorIndex >= 0) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "Could not find a matching route for errors on route IDs: " + Object.keys(errors).join(",")) : 0 : void 0;
    renderedMatches = renderedMatches.slice(0, Math.min(renderedMatches.length, errorIndex + 1));
  }

  // If we're in a partial hydration mode, detect if we need to render down to
  // a given HydrateFallback while we load the rest of the hydration data
  let renderFallback = false;
  let fallbackIndex = -1;
  if (dataRouterState && future && future.v7_partialHydration) {
    for (let i = 0; i < renderedMatches.length; i++) {
      let match = renderedMatches[i];
      // Track the deepest fallback up until the first route without data
      if (match.route.HydrateFallback || match.route.hydrateFallbackElement) {
        fallbackIndex = i;
      }
      if (match.route.id) {
        let {
          loaderData,
          errors
        } = dataRouterState;
        let needsToRunLoader = match.route.loader && loaderData[match.route.id] === undefined && (!errors || errors[match.route.id] === undefined);
        if (match.route.lazy || needsToRunLoader) {
          // We found the first route that's not ready to render (waiting on
          // lazy, or has a loader that hasn't run yet).  Flag that we need to
          // render a fallback and render up until the appropriate fallback
          renderFallback = true;
          if (fallbackIndex >= 0) {
            renderedMatches = renderedMatches.slice(0, fallbackIndex + 1);
          } else {
            renderedMatches = [renderedMatches[0]];
          }
          break;
        }
      }
    }
  }
  return renderedMatches.reduceRight((outlet, match, index) => {
    // Only data routers handle errors/fallbacks
    let error;
    let shouldRenderHydrateFallback = false;
    let errorElement = null;
    let hydrateFallbackElement = null;
    if (dataRouterState) {
      error = errors && match.route.id ? errors[match.route.id] : undefined;
      errorElement = match.route.errorElement || defaultErrorElement;
      if (renderFallback) {
        if (fallbackIndex < 0 && index === 0) {
          warningOnce("route-fallback", false, "No `HydrateFallback` element provided to render during initial hydration");
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = null;
        } else if (fallbackIndex === index) {
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = match.route.hydrateFallbackElement || null;
        }
      }
    }
    let matches = parentMatches.concat(renderedMatches.slice(0, index + 1));
    let getChildren = () => {
      let children;
      if (error) {
        children = errorElement;
      } else if (shouldRenderHydrateFallback) {
        children = hydrateFallbackElement;
      } else if (match.route.Component) {
        // Note: This is a de-optimized path since React won't re-use the
        // ReactElement since it's identity changes with each new
        // React.createElement call.  We keep this so folks can use
        // `<Route Component={...}>` in `<Routes>` but generally `Component`
        // usage is only advised in `RouterProvider` when we can convert it to
        // `element` ahead of time.
        children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(match.route.Component, null);
      } else if (match.route.element) {
        children = match.route.element;
      } else {
        children = outlet;
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderedRoute, {
        match: match,
        routeContext: {
          outlet,
          matches,
          isDataRoute: dataRouterState != null
        },
        children: children
      });
    };
    // Only wrap in an error boundary within data router usages when we have an
    // ErrorBoundary/errorElement on this route.  Otherwise let it bubble up to
    // an ancestor ErrorBoundary/errorElement
    return dataRouterState && (match.route.ErrorBoundary || match.route.errorElement || index === 0) ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderErrorBoundary, {
      location: dataRouterState.location,
      revalidation: dataRouterState.revalidation,
      component: errorElement,
      error: error,
      children: getChildren(),
      routeContext: {
        outlet: null,
        matches,
        isDataRoute: true
      }
    }) : getChildren();
  }, null);
}
var DataRouterHook = /*#__PURE__*/function (DataRouterHook) {
  DataRouterHook["UseBlocker"] = "useBlocker";
  DataRouterHook["UseRevalidator"] = "useRevalidator";
  DataRouterHook["UseNavigateStable"] = "useNavigate";
  return DataRouterHook;
}(DataRouterHook || {});
var DataRouterStateHook = /*#__PURE__*/function (DataRouterStateHook) {
  DataRouterStateHook["UseBlocker"] = "useBlocker";
  DataRouterStateHook["UseLoaderData"] = "useLoaderData";
  DataRouterStateHook["UseActionData"] = "useActionData";
  DataRouterStateHook["UseRouteError"] = "useRouteError";
  DataRouterStateHook["UseNavigation"] = "useNavigation";
  DataRouterStateHook["UseRouteLoaderData"] = "useRouteLoaderData";
  DataRouterStateHook["UseMatches"] = "useMatches";
  DataRouterStateHook["UseRevalidator"] = "useRevalidator";
  DataRouterStateHook["UseNavigateStable"] = "useNavigate";
  DataRouterStateHook["UseRouteId"] = "useRouteId";
  return DataRouterStateHook;
}(DataRouterStateHook || {});
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/v6/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  !ctx ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterStateContext);
  !state ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
function useRouteContext(hookName) {
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  !route ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return route;
}

// Internal version with hookName-aware debugging
function useCurrentRouteId(hookName) {
  let route = useRouteContext(hookName);
  let thisRoute = route.matches[route.matches.length - 1];
  !thisRoute.route.id ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, hookName + " can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  return thisRoute.route.id;
}

/**
 * Returns the ID for the nearest contextual route
 */
function useRouteId() {
  return useCurrentRouteId(DataRouterStateHook.UseRouteId);
}

/**
 * Returns the current navigation, defaulting to an "idle" navigation when
 * no navigation is in progress
 */
function useNavigation() {
  let state = useDataRouterState(DataRouterStateHook.UseNavigation);
  return state.navigation;
}

/**
 * Returns a revalidate function for manually triggering revalidation, as well
 * as the current state of any manual revalidations
 */
function useRevalidator() {
  let dataRouterContext = useDataRouterContext(DataRouterHook.UseRevalidator);
  let state = useDataRouterState(DataRouterStateHook.UseRevalidator);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    revalidate: dataRouterContext.router.revalidate,
    state: state.revalidation
  }), [dataRouterContext.router.revalidate, state.revalidation]);
}

/**
 * Returns the active route matches, useful for accessing loaderData for
 * parent/child routes or the route "handle" property
 */
function useMatches() {
  let {
    matches,
    loaderData
  } = useDataRouterState(DataRouterStateHook.UseMatches);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => matches.map(m => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_convertRouteMatchToUiMatch)(m, loaderData)), [matches, loaderData]);
}

/**
 * Returns the loader data for the nearest ancestor Route loader
 */
function useLoaderData() {
  let state = useDataRouterState(DataRouterStateHook.UseLoaderData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  if (state.errors && state.errors[routeId] != null) {
    console.error("You cannot `useLoaderData` in an errorElement (routeId: " + routeId + ")");
    return undefined;
  }
  return state.loaderData[routeId];
}

/**
 * Returns the loaderData for the given routeId
 */
function useRouteLoaderData(routeId) {
  let state = useDataRouterState(DataRouterStateHook.UseRouteLoaderData);
  return state.loaderData[routeId];
}

/**
 * Returns the action data for the nearest ancestor Route action
 */
function useActionData() {
  let state = useDataRouterState(DataRouterStateHook.UseActionData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  return state.actionData ? state.actionData[routeId] : undefined;
}

/**
 * Returns the nearest ancestor Route error, which could be a loader/action
 * error or a render error.  This is intended to be called from your
 * ErrorBoundary/errorElement to display a proper error message.
 */
function useRouteError() {
  var _state$errors;
  let error = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteErrorContext);
  let state = useDataRouterState(DataRouterStateHook.UseRouteError);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseRouteError);

  // If this was a render error, we put it in a RouteError context inside
  // of RenderErrorBoundary
  if (error !== undefined) {
    return error;
  }

  // Otherwise look for errors from our data router state
  return (_state$errors = state.errors) == null ? void 0 : _state$errors[routeId];
}

/**
 * Returns the happy-path data from the nearest ancestor `<Await />` value
 */
function useAsyncValue() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._data;
}

/**
 * Returns the error from the nearest ancestor `<Await />` value
 */
function useAsyncError() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._error;
}
let blockerId = 0;

/**
 * Allow the application to block navigations within the SPA and present the
 * user a confirmation dialog to confirm the navigation.  Mostly used to avoid
 * using half-filled form data.  This does not handle hard-reloads or
 * cross-origin navigations.
 */
function useBlocker(shouldBlock) {
  let {
    router,
    basename
  } = useDataRouterContext(DataRouterHook.UseBlocker);
  let state = useDataRouterState(DataRouterStateHook.UseBlocker);
  let [blockerKey, setBlockerKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState("");
  let blockerFunction = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(arg => {
    if (typeof shouldBlock !== "function") {
      return !!shouldBlock;
    }
    if (basename === "/") {
      return shouldBlock(arg);
    }

    // If they provided us a function and we've got an active basename, strip
    // it from the locations we expose to the user to match the behavior of
    // useLocation
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = arg;
    return shouldBlock({
      currentLocation: _extends({}, currentLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(currentLocation.pathname, basename) || currentLocation.pathname
      }),
      nextLocation: _extends({}, nextLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(nextLocation.pathname, basename) || nextLocation.pathname
      }),
      historyAction
    });
  }, [basename, shouldBlock]);

  // This effect is in charge of blocker key assignment and deletion (which is
  // tightly coupled to the key)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let key = String(++blockerId);
    setBlockerKey(key);
    return () => router.deleteBlocker(key);
  }, [router]);

  // This effect handles assigning the blockerFunction.  This is to handle
  // unstable blocker function identities, and happens only after the prior
  // effect so we don't get an orphaned blockerFunction in the router with a
  // key of "".  Until then we just have the IDLE_BLOCKER.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blockerKey !== "") {
      router.getBlocker(blockerKey, blockerFunction);
    }
  }, [router, blockerKey, blockerFunction]);

  // Prefer the blocker from `state` not `router.state` since DataRouterContext
  // is memoized so this ensures we update on blocker state updates
  return blockerKey && state.blockers.has(blockerKey) ? state.blockers.get(blockerKey) : _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.IDLE_BLOCKER;
}

/**
 * Stable version of useNavigate that is used when we are in the context of
 * a RouterProvider.
 */
function useNavigateStable() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseNavigateStable);
  let id = useCurrentRouteId(DataRouterStateHook.UseNavigateStable);
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our router subscriber yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      router.navigate(to);
    } else {
      router.navigate(to, _extends({
        fromRouteId: id
      }, options));
    }
  }, [router, id]);
  return navigate;
}
const alreadyWarned$1 = {};
function warningOnce(key, cond, message) {
  if (!cond && !alreadyWarned$1[key]) {
    alreadyWarned$1[key] = true;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, message) : 0;
  }
}

const alreadyWarned = {};
function warnOnce(key, message) {
  if ( true && !alreadyWarned[message]) {
    alreadyWarned[message] = true;
    console.warn(message);
  }
}
const logDeprecation = (flag, msg, link) => warnOnce(flag, "\u26A0\uFE0F React Router Future Flag Warning: " + msg + ". " + ("You can use the `" + flag + "` future flag to opt-in early. ") + ("For more information, see " + link + "."));
function logV6DeprecationWarnings(renderFuture, routerFuture) {
  if ((renderFuture == null ? void 0 : renderFuture.v7_startTransition) === undefined) {
    logDeprecation("v7_startTransition", "React Router will begin wrapping state updates in `React.startTransition` in v7", "https://reactrouter.com/v6/upgrading/future#v7_starttransition");
  }
  if ((renderFuture == null ? void 0 : renderFuture.v7_relativeSplatPath) === undefined && (!routerFuture || routerFuture.v7_relativeSplatPath === undefined)) {
    logDeprecation("v7_relativeSplatPath", "Relative route resolution within Splat routes is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_relativesplatpath");
  }
  if (routerFuture) {
    if (routerFuture.v7_fetcherPersist === undefined) {
      logDeprecation("v7_fetcherPersist", "The persistence behavior of fetchers is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_fetcherpersist");
    }
    if (routerFuture.v7_normalizeFormMethod === undefined) {
      logDeprecation("v7_normalizeFormMethod", "Casing of `formMethod` fields is being normalized to uppercase in v7", "https://reactrouter.com/v6/upgrading/future#v7_normalizeformmethod");
    }
    if (routerFuture.v7_partialHydration === undefined) {
      logDeprecation("v7_partialHydration", "`RouterProvider` hydration behavior is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_partialhydration");
    }
    if (routerFuture.v7_skipActionErrorRevalidation === undefined) {
      logDeprecation("v7_skipActionErrorRevalidation", "The revalidation behavior after 4xx/5xx `action` responses is changing in v7", "https://reactrouter.com/v6/upgrading/future#v7_skipactionerrorrevalidation");
    }
  }
}

/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];

/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    if (v7_startTransition && startTransitionImpl) {
      startTransitionImpl(() => setStateImpl(newState));
    } else {
      setStateImpl(newState);
    }
  }, [setStateImpl, v7_startTransition]);

  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => logV6DeprecationWarnings(future, router.future), [router, future]);

  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: {
      v7_relativeSplatPath: router.future.v7_relativeSplatPath
    }
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))), null);
}
function DataRoutes(_ref2) {
  let {
    routes,
    future,
    state
  } = _ref2;
  return useRoutesImpl(routes, undefined, state, future);
}
/**
 * A `<Router>` that stores all entries in memory.
 *
 * @see https://reactrouter.com/v6/router-components/memory-router
 */
function MemoryRouter(_ref3) {
  let {
    basename,
    children,
    initialEntries,
    initialIndex,
    future
  } = _ref3;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries,
      initialIndex,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => logV6DeprecationWarnings(future), [future]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * Changes the current location.
 *
 * Note: This API is mostly useful in React.Component subclasses that are not
 * able to use hooks. In functional components, we recommend you use the
 * `useNavigate` hook instead.
 *
 * @see https://reactrouter.com/v6/components/navigate
 */
function Navigate(_ref4) {
  let {
    to,
    replace,
    state,
    relative
  } = _ref4;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of
  // the router loaded. We can help them understand how to avoid that.
  "<Navigate> may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    future,
    static: isStatic
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(!isStatic, "<Navigate> must not be used on the initial render in a <StaticRouter>. " + "This is a no-op, but you should modify your code so the <Navigate> is " + "only ever rendered in response to some user interaction or state change.") : 0;
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let navigate = useNavigate();

  // Resolve the path outside of the effect so that when effects run twice in
  // StrictMode they navigate to the same place
  let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath), locationPathname, relative === "path");
  let jsonPath = JSON.stringify(path);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => navigate(JSON.parse(jsonPath), {
    replace,
    state,
    relative
  }), [navigate, jsonPath, relative, replace, state]);
  return null;
}
/**
 * Renders the child route's element, if there is one.
 *
 * @see https://reactrouter.com/v6/components/outlet
 */
function Outlet(props) {
  return useOutlet(props.context);
}
/**
 * Declares an element that should be rendered at a certain URL path.
 *
 * @see https://reactrouter.com/v6/components/route
 */
function Route(_props) {
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "A <Route> is only ever to be used as the child of <Routes> element, " + "never rendered directly. Please wrap your <Route> in a <Routes>.") : 0 ;
}
/**
 * Provides location context for the rest of the app.
 *
 * Note: You usually won't render a `<Router>` directly. Instead, you'll render a
 * router that is more specific to your environment such as a `<BrowserRouter>`
 * in web browsers or a `<StaticRouter>` for server rendering.
 *
 * @see https://reactrouter.com/v6/router-components/router
 */
function Router(_ref5) {
  let {
    basename: basenameProp = "/",
    children = null,
    location: locationProp,
    navigationType = _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop,
    navigator,
    static: staticProp = false,
    future
  } = _ref5;
  !!useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "You cannot render a <Router> inside another <Router>." + " You should never have more than one in your app.") : 0 : void 0;

  // Preserve trailing slashes on basename, so we can let the user control
  // the enforcement of trailing slashes throughout the app
  let basename = basenameProp.replace(/^\/*/, "/");
  let navigationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    basename,
    navigator,
    static: staticProp,
    future: _extends({
      v7_relativeSplatPath: false
    }, future)
  }), [basename, future, navigator, staticProp]);
  if (typeof locationProp === "string") {
    locationProp = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationProp);
  }
  let {
    pathname = "/",
    search = "",
    hash = "",
    state = null,
    key = "default"
  } = locationProp;
  let locationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let trailingPathname = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(pathname, basename);
    if (trailingPathname == null) {
      return null;
    }
    return {
      location: {
        pathname: trailingPathname,
        search,
        hash,
        state,
        key
      },
      navigationType
    };
  }, [basename, pathname, search, hash, state, key, navigationType]);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(locationContext != null, "<Router basename=\"" + basename + "\"> is not able to match the URL " + ("\"" + pathname + search + hash + "\" because it does not start with the ") + "basename, so the <Router> won't render anything.") : 0;
  if (locationContext == null) {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(NavigationContext.Provider, {
    value: navigationContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
    children: children,
    value: locationContext
  }));
}
/**
 * A container for a nested tree of `<Route>` elements that renders the branch
 * that best matches the current location.
 *
 * @see https://reactrouter.com/v6/components/routes
 */
function Routes(_ref6) {
  let {
    children,
    location
  } = _ref6;
  return useRoutes(createRoutesFromChildren(children), location);
}
/**
 * Component to use for rendering lazily loaded data from returning defer()
 * in a loader function
 */
function Await(_ref7) {
  let {
    children,
    errorElement,
    resolve
  } = _ref7;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitErrorBoundary, {
    resolve: resolve,
    errorElement: errorElement
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResolveAwait, null, children));
}
var AwaitRenderStatus = /*#__PURE__*/function (AwaitRenderStatus) {
  AwaitRenderStatus[AwaitRenderStatus["pending"] = 0] = "pending";
  AwaitRenderStatus[AwaitRenderStatus["success"] = 1] = "success";
  AwaitRenderStatus[AwaitRenderStatus["error"] = 2] = "error";
  return AwaitRenderStatus;
}(AwaitRenderStatus || {});
const neverSettledPromise = new Promise(() => {});
class AwaitErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("<Await> caught the following error during render", error, errorInfo);
  }
  render() {
    let {
      children,
      errorElement,
      resolve
    } = this.props;
    let promise = null;
    let status = AwaitRenderStatus.pending;
    if (!(resolve instanceof Promise)) {
      // Didn't get a promise - provide as a resolved promise
      status = AwaitRenderStatus.success;
      promise = Promise.resolve();
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_data", {
        get: () => resolve
      });
    } else if (this.state.error) {
      // Caught a render error, provide it as a rejected promise
      status = AwaitRenderStatus.error;
      let renderError = this.state.error;
      promise = Promise.reject().catch(() => {}); // Avoid unhandled rejection warnings
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_error", {
        get: () => renderError
      });
    } else if (resolve._tracked) {
      // Already tracked promise - check contents
      promise = resolve;
      status = "_error" in promise ? AwaitRenderStatus.error : "_data" in promise ? AwaitRenderStatus.success : AwaitRenderStatus.pending;
    } else {
      // Raw (untracked) promise - track it
      status = AwaitRenderStatus.pending;
      Object.defineProperty(resolve, "_tracked", {
        get: () => true
      });
      promise = resolve.then(data => Object.defineProperty(resolve, "_data", {
        get: () => data
      }), error => Object.defineProperty(resolve, "_error", {
        get: () => error
      }));
    }
    if (status === AwaitRenderStatus.error && promise._error instanceof _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError) {
      // Freeze the UI by throwing a never resolved promise
      throw neverSettledPromise;
    }
    if (status === AwaitRenderStatus.error && !errorElement) {
      // No errorElement, throw to the nearest route-level error boundary
      throw promise._error;
    }
    if (status === AwaitRenderStatus.error) {
      // Render via our errorElement
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: errorElement
      });
    }
    if (status === AwaitRenderStatus.success) {
      // Render children with resolved value
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: children
      });
    }

    // Throw to the suspense boundary
    throw promise;
  }
}

/**
 * @private
 * Indirection to leverage useAsyncValue for a render-prop API on `<Await>`
 */
function ResolveAwait(_ref8) {
  let {
    children
  } = _ref8;
  let data = useAsyncValue();
  let toRender = typeof children === "function" ? children(data) : children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, toRender);
}

///////////////////////////////////////////////////////////////////////////////
// UTILS
///////////////////////////////////////////////////////////////////////////////

/**
 * Creates a route config from a React "children" object, which is usually
 * either a `<Route>` element or an array of them. Used internally by
 * `<Routes>` to create a route config from its children.
 *
 * @see https://reactrouter.com/v6/utils/create-routes-from-children
 */
function createRoutesFromChildren(children, parentPath) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  let routes = [];
  react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (element, index) => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(element)) {
      // Ignore non-elements. This allows people to more easily inline
      // conditionals in their route config.
      return;
    }
    let treePath = [...parentPath, index];
    if (element.type === react__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
      // Transparently support React.Fragment and its children.
      routes.push.apply(routes, createRoutesFromChildren(element.props.children, treePath));
      return;
    }
    !(element.type === Route) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "[" + (typeof element.type === "string" ? element.type : element.type.name) + "] is not a <Route> component. All component children of <Routes> must be a <Route> or <React.Fragment>") : 0 : void 0;
    !(!element.props.index || !element.props.children) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "An index route cannot have child routes.") : 0 : void 0;
    let route = {
      id: element.props.id || treePath.join("-"),
      caseSensitive: element.props.caseSensitive,
      element: element.props.element,
      Component: element.props.Component,
      index: element.props.index,
      path: element.props.path,
      loader: element.props.loader,
      action: element.props.action,
      errorElement: element.props.errorElement,
      ErrorBoundary: element.props.ErrorBoundary,
      hasErrorBoundary: element.props.ErrorBoundary != null || element.props.errorElement != null,
      shouldRevalidate: element.props.shouldRevalidate,
      handle: element.props.handle,
      lazy: element.props.lazy
    };
    if (element.props.children) {
      route.children = createRoutesFromChildren(element.props.children, treePath);
    }
    routes.push(route);
  });
  return routes;
}

/**
 * Renders the result of `matchRoutes()` into a React element.
 */
function renderMatches(matches) {
  return _renderMatches(matches);
}

function mapRouteProperties(route) {
  let updates = {
    // Note: this check also occurs in createRoutesFromChildren so update
    // there if you change this -- please and thank you!
    hasErrorBoundary: route.ErrorBoundary != null || route.errorElement != null
  };
  if (route.Component) {
    if (true) {
      if (route.element) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `Component` and `element` on your route - " + "`Component` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      element: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.Component),
      Component: undefined
    });
  }
  if (route.HydrateFallback) {
    if (true) {
      if (route.hydrateFallbackElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `HydrateFallback` and `hydrateFallbackElement` on your route - " + "`HydrateFallback` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      hydrateFallbackElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.HydrateFallback),
      HydrateFallback: undefined
    });
  }
  if (route.ErrorBoundary) {
    if (true) {
      if (route.errorElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `ErrorBoundary` and `errorElement` on your route - " + "`ErrorBoundary` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      errorElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.ErrorBoundary),
      ErrorBoundary: undefined
    });
  }
  return updates;
}
function createMemoryRouter(routes, opts) {
  return (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries: opts == null ? void 0 : opts.initialEntries,
      initialIndex: opts == null ? void 0 : opts.initialIndex
    }),
    hydrationData: opts == null ? void 0 : opts.hydrationData,
    routes,
    mapRouteProperties,
    dataStrategy: opts == null ? void 0 : opts.dataStrategy,
    patchRoutesOnNavigation: opts == null ? void 0 : opts.patchRoutesOnNavigation
  }).initialize();
}


//# sourceMappingURL=index.js.map


/***/ },

/***/ "./src/assets/img/GDPR.jpg"
/*!*********************************!*\
  !*** ./src/assets/img/GDPR.jpg ***!
  \*********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/GDPR.d1985fe1.jpg";

/***/ },

/***/ "./src/assets/img/SEO.jpg"
/*!********************************!*\
  !*** ./src/assets/img/SEO.jpg ***!
  \********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/SEO.137b0311.jpg";

/***/ },

/***/ "./src/assets/img/demo-2.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-2.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-2.8491a9c0.png";

/***/ },

/***/ "./src/assets/img/demo-3.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-3.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-3.b79c93ba.png";

/***/ },

/***/ "./src/assets/img/demo-4.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-4.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-4.3c78bece.png";

/***/ },

/***/ "./src/assets/img/demo-5.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-5.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-5.42e4849d.png";

/***/ },

/***/ "./src/assets/img/demo-6.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-6.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-6.6e681cbe.png";

/***/ },

/***/ "./src/assets/img/demo-7.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-7.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-7.81adeb66.png";

/***/ },

/***/ "./src/assets/img/demo-8.png"
/*!***********************************!*\
  !*** ./src/assets/img/demo-8.png ***!
  \***********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/demo-8.43748282.png";

/***/ },

/***/ "./src/assets/img/freevspro.webp"
/*!***************************************!*\
  !*** ./src/assets/img/freevspro.webp ***!
  \***************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/freevspro.ec770268.webp";

/***/ },

/***/ "./src/assets/img/logo.png"
/*!*********************************!*\
  !*** ./src/assets/img/logo.png ***!
  \*********************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/logo.c7acedf2.png";

/***/ },

/***/ "./src/assets/img/main-demo.png"
/*!**************************************!*\
  !*** ./src/assets/img/main-demo.png ***!
  \**************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/main-demo.4a0ec047.png";

/***/ },

/***/ "./src/assets/img/pluginsSetup.jpg"
/*!*****************************************!*\
  !*** ./src/assets/img/pluginsSetup.jpg ***!
  \*****************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/pluginsSetup.504fe50e.jpg";

/***/ },

/***/ "./src/assets/img/themeClub.webp"
/*!***************************************!*\
  !*** ./src/assets/img/themeClub.webp ***!
  \***************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeClub.05fad285.webp";

/***/ },

/***/ "./src/assets/img/themeInstallation.jpg"
/*!**********************************************!*\
  !*** ./src/assets/img/themeInstallation.jpg ***!
  \**********************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/themeInstallation.adb57799.jpg";

/***/ },

/***/ "./src/assets/img/vipSupport.jpg"
/*!***************************************!*\
  !*** ./src/assets/img/vipSupport.jpg ***!
  \***************************************/
(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/vipSupport.361dc737.jpg";

/***/ },

/***/ "react"
/*!************************!*\
  !*** external "React" ***!
  \************************/
(module) {

module.exports = window["React"];

/***/ },

/***/ "react-dom"
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
(module) {

module.exports = window["ReactDOM"];

/***/ },

/***/ "@wordpress/dom-ready"
/*!**********************************!*\
  !*** external ["wp","domReady"] ***!
  \**********************************/
(module) {

module.exports = window["wp"]["domReady"];

/***/ },

/***/ "@wordpress/element"
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
(module) {

module.exports = window["wp"]["element"];

/***/ },

/***/ "@wordpress/i18n"
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
(module) {

module.exports = window["wp"]["i18n"];

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (globalThis.importScripts) scriptUrl = globalThis.location + "";
/******/ 		var document = globalThis.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript && document.currentScript.tagName.toUpperCase() === 'SCRIPT')
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/^blob:/, "").replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _pages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./pages */ "./src/pages/index.js");
/* harmony import */ var _scss_style_scss__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./scss/style.scss */ "./src/scss/style.scss");






_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default()(() => {
  const root = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createRoot)(document.getElementById('cw-dashboard'));
  root.render((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.BrowserRouter, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages__WEBPACK_IMPORTED_MODULE_4__["default"], null))));
});
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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